// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.PolicyComplianceState;
import java.io.IOException;

/**
 * AllPolicies Properties.
 */
@Fluent
public final class AllPoliciesContractProperties implements JsonSerializable<AllPoliciesContractProperties> {
    /*
     * Policy Identifier
     */
    private String referencePolicyId;

    /*
     * Policy Restriction Compliance State
     */
    private PolicyComplianceState complianceState;

    /**
     * Creates an instance of AllPoliciesContractProperties class.
     */
    public AllPoliciesContractProperties() {
    }

    /**
     * Get the referencePolicyId property: Policy Identifier.
     * 
     * @return the referencePolicyId value.
     */
    public String referencePolicyId() {
        return this.referencePolicyId;
    }

    /**
     * Set the referencePolicyId property: Policy Identifier.
     * 
     * @param referencePolicyId the referencePolicyId value to set.
     * @return the AllPoliciesContractProperties object itself.
     */
    public AllPoliciesContractProperties withReferencePolicyId(String referencePolicyId) {
        this.referencePolicyId = referencePolicyId;
        return this;
    }

    /**
     * Get the complianceState property: Policy Restriction Compliance State.
     * 
     * @return the complianceState value.
     */
    public PolicyComplianceState complianceState() {
        return this.complianceState;
    }

    /**
     * Set the complianceState property: Policy Restriction Compliance State.
     * 
     * @param complianceState the complianceState value to set.
     * @return the AllPoliciesContractProperties object itself.
     */
    public AllPoliciesContractProperties withComplianceState(PolicyComplianceState complianceState) {
        this.complianceState = complianceState;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("referencePolicyId", this.referencePolicyId);
        jsonWriter.writeStringField("complianceState",
            this.complianceState == null ? null : this.complianceState.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AllPoliciesContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AllPoliciesContractProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AllPoliciesContractProperties.
     */
    public static AllPoliciesContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AllPoliciesContractProperties deserializedAllPoliciesContractProperties
                = new AllPoliciesContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("referencePolicyId".equals(fieldName)) {
                    deserializedAllPoliciesContractProperties.referencePolicyId = reader.getString();
                } else if ("complianceState".equals(fieldName)) {
                    deserializedAllPoliciesContractProperties.complianceState
                        = PolicyComplianceState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAllPoliciesContractProperties;
        });
    }
}
