// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ApiContactInformation;
import com.azure.resourcemanager.apimanagement.models.ApiLicenseInformation;
import com.azure.resourcemanager.apimanagement.models.ApiType;
import com.azure.resourcemanager.apimanagement.models.ApiVersionSetContractDetails;
import com.azure.resourcemanager.apimanagement.models.AuthenticationSettingsContract;
import com.azure.resourcemanager.apimanagement.models.Protocol;
import com.azure.resourcemanager.apimanagement.models.SubscriptionKeyParameterNamesContract;
import java.io.IOException;
import java.util.List;

/**
 * API details.
 */
@Fluent
public final class ApiContractInner extends ProxyResource {
    /*
     * API entity contract properties.
     */
    private ApiContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ApiContractInner class.
     */
    public ApiContractInner() {
    }

    /**
     * Get the innerProperties property: API entity contract properties.
     * 
     * @return the innerProperties value.
     */
    private ApiContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the sourceApiId property: API identifier of the source API.
     * 
     * @return the sourceApiId value.
     */
    public String sourceApiId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceApiId();
    }

    /**
     * Set the sourceApiId property: API identifier of the source API.
     * 
     * @param sourceApiId the sourceApiId value to set.
     * @return the ApiContractInner object itself.
     */
    public ApiContractInner withSourceApiId(String sourceApiId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiContractProperties();
        }
        this.innerProperties().withSourceApiId(sourceApiId);
        return this;
    }

    /**
     * Get the displayName property: API name. Must be 1 to 300 characters long.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: API name. Must be 1 to 300 characters long.
     * 
     * @param displayName the displayName value to set.
     * @return the ApiContractInner object itself.
     */
    public ApiContractInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiContractProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the serviceUrl property: Absolute URL of the backend service implementing this API. Cannot be more than 2000
     * characters long.
     * 
     * @return the serviceUrl value.
     */
    public String serviceUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceUrl();
    }

    /**
     * Set the serviceUrl property: Absolute URL of the backend service implementing this API. Cannot be more than 2000
     * characters long.
     * 
     * @param serviceUrl the serviceUrl value to set.
     * @return the ApiContractInner object itself.
     */
    public ApiContractInner withServiceUrl(String serviceUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiContractProperties();
        }
        this.innerProperties().withServiceUrl(serviceUrl);
        return this;
    }

    /**
     * Get the path property: Relative URL uniquely identifying this API and all of its resource paths within the API
     * Management service instance. It is appended to the API endpoint base URL specified during the service instance
     * creation to form a public URL for this API.
     * 
     * @return the path value.
     */
    public String path() {
        return this.innerProperties() == null ? null : this.innerProperties().path();
    }

    /**
     * Set the path property: Relative URL uniquely identifying this API and all of its resource paths within the API
     * Management service instance. It is appended to the API endpoint base URL specified during the service instance
     * creation to form a public URL for this API.
     * 
     * @param path the path value to set.
     * @return the ApiContractInner object itself.
     */
    public ApiContractInner withPath(String path) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiContractProperties();
        }
        this.innerProperties().withPath(path);
        return this;
    }

    /**
     * Get the protocols property: Describes on which protocols the operations in this API can be invoked.
     * 
     * @return the protocols value.
     */
    public List<Protocol> protocols() {
        return this.innerProperties() == null ? null : this.innerProperties().protocols();
    }

    /**
     * Set the protocols property: Describes on which protocols the operations in this API can be invoked.
     * 
     * @param protocols the protocols value to set.
     * @return the ApiContractInner object itself.
     */
    public ApiContractInner withProtocols(List<Protocol> protocols) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiContractProperties();
        }
        this.innerProperties().withProtocols(protocols);
        return this;
    }

    /**
     * Get the apiVersionSet property: Version set details.
     * 
     * @return the apiVersionSet value.
     */
    public ApiVersionSetContractDetails apiVersionSet() {
        return this.innerProperties() == null ? null : this.innerProperties().apiVersionSet();
    }

    /**
     * Set the apiVersionSet property: Version set details.
     * 
     * @param apiVersionSet the apiVersionSet value to set.
     * @return the ApiContractInner object itself.
     */
    public ApiContractInner withApiVersionSet(ApiVersionSetContractDetails apiVersionSet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiContractProperties();
        }
        this.innerProperties().withApiVersionSet(apiVersionSet);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the description property: Description of the API. May include HTML formatting tags.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Description of the API. May include HTML formatting tags.
     * 
     * @param description the description value to set.
     * @return the ApiContractInner object itself.
     */
    public ApiContractInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiContractProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the authenticationSettings property: Collection of authentication settings included into this API.
     * 
     * @return the authenticationSettings value.
     */
    public AuthenticationSettingsContract authenticationSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().authenticationSettings();
    }

    /**
     * Set the authenticationSettings property: Collection of authentication settings included into this API.
     * 
     * @param authenticationSettings the authenticationSettings value to set.
     * @return the ApiContractInner object itself.
     */
    public ApiContractInner withAuthenticationSettings(AuthenticationSettingsContract authenticationSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiContractProperties();
        }
        this.innerProperties().withAuthenticationSettings(authenticationSettings);
        return this;
    }

    /**
     * Get the subscriptionKeyParameterNames property: Protocols over which API is made available.
     * 
     * @return the subscriptionKeyParameterNames value.
     */
    public SubscriptionKeyParameterNamesContract subscriptionKeyParameterNames() {
        return this.innerProperties() == null ? null : this.innerProperties().subscriptionKeyParameterNames();
    }

    /**
     * Set the subscriptionKeyParameterNames property: Protocols over which API is made available.
     * 
     * @param subscriptionKeyParameterNames the subscriptionKeyParameterNames value to set.
     * @return the ApiContractInner object itself.
     */
    public ApiContractInner
        withSubscriptionKeyParameterNames(SubscriptionKeyParameterNamesContract subscriptionKeyParameterNames) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiContractProperties();
        }
        this.innerProperties().withSubscriptionKeyParameterNames(subscriptionKeyParameterNames);
        return this;
    }

    /**
     * Get the apiType property: Type of API.
     * 
     * @return the apiType value.
     */
    public ApiType apiType() {
        return this.innerProperties() == null ? null : this.innerProperties().apiType();
    }

    /**
     * Set the apiType property: Type of API.
     * 
     * @param apiType the apiType value to set.
     * @return the ApiContractInner object itself.
     */
    public ApiContractInner withApiType(ApiType apiType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiContractProperties();
        }
        this.innerProperties().withApiType(apiType);
        return this;
    }

    /**
     * Get the apiRevision property: Describes the revision of the API. If no value is provided, default revision 1 is
     * created.
     * 
     * @return the apiRevision value.
     */
    public String apiRevision() {
        return this.innerProperties() == null ? null : this.innerProperties().apiRevision();
    }

    /**
     * Set the apiRevision property: Describes the revision of the API. If no value is provided, default revision 1 is
     * created.
     * 
     * @param apiRevision the apiRevision value to set.
     * @return the ApiContractInner object itself.
     */
    public ApiContractInner withApiRevision(String apiRevision) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiContractProperties();
        }
        this.innerProperties().withApiRevision(apiRevision);
        return this;
    }

    /**
     * Get the apiVersion property: Indicates the version identifier of the API if the API is versioned.
     * 
     * @return the apiVersion value.
     */
    public String apiVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().apiVersion();
    }

    /**
     * Set the apiVersion property: Indicates the version identifier of the API if the API is versioned.
     * 
     * @param apiVersion the apiVersion value to set.
     * @return the ApiContractInner object itself.
     */
    public ApiContractInner withApiVersion(String apiVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiContractProperties();
        }
        this.innerProperties().withApiVersion(apiVersion);
        return this;
    }

    /**
     * Get the isCurrent property: Indicates if API revision is current api revision.
     * 
     * @return the isCurrent value.
     */
    public Boolean isCurrent() {
        return this.innerProperties() == null ? null : this.innerProperties().isCurrent();
    }

    /**
     * Set the isCurrent property: Indicates if API revision is current api revision.
     * 
     * @param isCurrent the isCurrent value to set.
     * @return the ApiContractInner object itself.
     */
    public ApiContractInner withIsCurrent(Boolean isCurrent) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiContractProperties();
        }
        this.innerProperties().withIsCurrent(isCurrent);
        return this;
    }

    /**
     * Get the isOnline property: Indicates if API revision is accessible via the gateway.
     * 
     * @return the isOnline value.
     */
    public Boolean isOnline() {
        return this.innerProperties() == null ? null : this.innerProperties().isOnline();
    }

    /**
     * Get the apiRevisionDescription property: Description of the API Revision.
     * 
     * @return the apiRevisionDescription value.
     */
    public String apiRevisionDescription() {
        return this.innerProperties() == null ? null : this.innerProperties().apiRevisionDescription();
    }

    /**
     * Set the apiRevisionDescription property: Description of the API Revision.
     * 
     * @param apiRevisionDescription the apiRevisionDescription value to set.
     * @return the ApiContractInner object itself.
     */
    public ApiContractInner withApiRevisionDescription(String apiRevisionDescription) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiContractProperties();
        }
        this.innerProperties().withApiRevisionDescription(apiRevisionDescription);
        return this;
    }

    /**
     * Get the apiVersionDescription property: Description of the API Version.
     * 
     * @return the apiVersionDescription value.
     */
    public String apiVersionDescription() {
        return this.innerProperties() == null ? null : this.innerProperties().apiVersionDescription();
    }

    /**
     * Set the apiVersionDescription property: Description of the API Version.
     * 
     * @param apiVersionDescription the apiVersionDescription value to set.
     * @return the ApiContractInner object itself.
     */
    public ApiContractInner withApiVersionDescription(String apiVersionDescription) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiContractProperties();
        }
        this.innerProperties().withApiVersionDescription(apiVersionDescription);
        return this;
    }

    /**
     * Get the apiVersionSetId property: A resource identifier for the related ApiVersionSet.
     * 
     * @return the apiVersionSetId value.
     */
    public String apiVersionSetId() {
        return this.innerProperties() == null ? null : this.innerProperties().apiVersionSetId();
    }

    /**
     * Set the apiVersionSetId property: A resource identifier for the related ApiVersionSet.
     * 
     * @param apiVersionSetId the apiVersionSetId value to set.
     * @return the ApiContractInner object itself.
     */
    public ApiContractInner withApiVersionSetId(String apiVersionSetId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiContractProperties();
        }
        this.innerProperties().withApiVersionSetId(apiVersionSetId);
        return this;
    }

    /**
     * Get the subscriptionRequired property: Specifies whether an API or Product subscription is required for accessing
     * the API.
     * 
     * @return the subscriptionRequired value.
     */
    public Boolean subscriptionRequired() {
        return this.innerProperties() == null ? null : this.innerProperties().subscriptionRequired();
    }

    /**
     * Set the subscriptionRequired property: Specifies whether an API or Product subscription is required for accessing
     * the API.
     * 
     * @param subscriptionRequired the subscriptionRequired value to set.
     * @return the ApiContractInner object itself.
     */
    public ApiContractInner withSubscriptionRequired(Boolean subscriptionRequired) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiContractProperties();
        }
        this.innerProperties().withSubscriptionRequired(subscriptionRequired);
        return this;
    }

    /**
     * Get the termsOfServiceUrl property: A URL to the Terms of Service for the API. MUST be in the format of a URL.
     * 
     * @return the termsOfServiceUrl value.
     */
    public String termsOfServiceUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().termsOfServiceUrl();
    }

    /**
     * Set the termsOfServiceUrl property: A URL to the Terms of Service for the API. MUST be in the format of a URL.
     * 
     * @param termsOfServiceUrl the termsOfServiceUrl value to set.
     * @return the ApiContractInner object itself.
     */
    public ApiContractInner withTermsOfServiceUrl(String termsOfServiceUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiContractProperties();
        }
        this.innerProperties().withTermsOfServiceUrl(termsOfServiceUrl);
        return this;
    }

    /**
     * Get the contact property: Contact information for the API.
     * 
     * @return the contact value.
     */
    public ApiContactInformation contact() {
        return this.innerProperties() == null ? null : this.innerProperties().contact();
    }

    /**
     * Set the contact property: Contact information for the API.
     * 
     * @param contact the contact value to set.
     * @return the ApiContractInner object itself.
     */
    public ApiContractInner withContact(ApiContactInformation contact) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiContractProperties();
        }
        this.innerProperties().withContact(contact);
        return this;
    }

    /**
     * Get the license property: License information for the API.
     * 
     * @return the license value.
     */
    public ApiLicenseInformation license() {
        return this.innerProperties() == null ? null : this.innerProperties().license();
    }

    /**
     * Set the license property: License information for the API.
     * 
     * @param license the license value to set.
     * @return the ApiContractInner object itself.
     */
    public ApiContractInner withLicense(ApiLicenseInformation license) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiContractProperties();
        }
        this.innerProperties().withLicense(license);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiContractInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApiContractInner.
     */
    public static ApiContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiContractInner deserializedApiContractInner = new ApiContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApiContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedApiContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedApiContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedApiContractInner.innerProperties = ApiContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiContractInner;
        });
    }
}
