// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ApiContactInformation;
import com.azure.resourcemanager.apimanagement.models.ApiEntityBaseContract;
import com.azure.resourcemanager.apimanagement.models.ApiLicenseInformation;
import com.azure.resourcemanager.apimanagement.models.ApiType;
import com.azure.resourcemanager.apimanagement.models.ApiVersionSetContractDetails;
import com.azure.resourcemanager.apimanagement.models.AuthenticationSettingsContract;
import com.azure.resourcemanager.apimanagement.models.Protocol;
import com.azure.resourcemanager.apimanagement.models.SubscriptionKeyParameterNamesContract;
import java.io.IOException;
import java.util.List;

/**
 * API Entity Properties.
 */
@Fluent
public class ApiContractProperties extends ApiEntityBaseContract {
    /*
     * API identifier of the source API.
     */
    private String sourceApiId;

    /*
     * API name. Must be 1 to 300 characters long.
     */
    private String displayName;

    /*
     * Absolute URL of the backend service implementing this API. Cannot be more than 2000 characters long.
     */
    private String serviceUrl;

    /*
     * Relative URL uniquely identifying this API and all of its resource paths within the API Management service
     * instance. It is appended to the API endpoint base URL specified during the service instance creation to form a
     * public URL for this API.
     */
    private String path;

    /*
     * Describes on which protocols the operations in this API can be invoked.
     */
    private List<Protocol> protocols;

    /*
     * Version set details
     */
    private ApiVersionSetContractDetails apiVersionSet;

    /*
     * The provisioning state
     */
    private String provisioningState;

    /*
     * Indicates if API revision is accessible via the gateway.
     */
    private Boolean isOnline;

    /**
     * Creates an instance of ApiContractProperties class.
     */
    public ApiContractProperties() {
    }

    /**
     * Get the sourceApiId property: API identifier of the source API.
     * 
     * @return the sourceApiId value.
     */
    public String sourceApiId() {
        return this.sourceApiId;
    }

    /**
     * Set the sourceApiId property: API identifier of the source API.
     * 
     * @param sourceApiId the sourceApiId value to set.
     * @return the ApiContractProperties object itself.
     */
    public ApiContractProperties withSourceApiId(String sourceApiId) {
        this.sourceApiId = sourceApiId;
        return this;
    }

    /**
     * Get the displayName property: API name. Must be 1 to 300 characters long.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: API name. Must be 1 to 300 characters long.
     * 
     * @param displayName the displayName value to set.
     * @return the ApiContractProperties object itself.
     */
    public ApiContractProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the serviceUrl property: Absolute URL of the backend service implementing this API. Cannot be more than 2000
     * characters long.
     * 
     * @return the serviceUrl value.
     */
    public String serviceUrl() {
        return this.serviceUrl;
    }

    /**
     * Set the serviceUrl property: Absolute URL of the backend service implementing this API. Cannot be more than 2000
     * characters long.
     * 
     * @param serviceUrl the serviceUrl value to set.
     * @return the ApiContractProperties object itself.
     */
    public ApiContractProperties withServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
        return this;
    }

    /**
     * Get the path property: Relative URL uniquely identifying this API and all of its resource paths within the API
     * Management service instance. It is appended to the API endpoint base URL specified during the service instance
     * creation to form a public URL for this API.
     * 
     * @return the path value.
     */
    public String path() {
        return this.path;
    }

    /**
     * Set the path property: Relative URL uniquely identifying this API and all of its resource paths within the API
     * Management service instance. It is appended to the API endpoint base URL specified during the service instance
     * creation to form a public URL for this API.
     * 
     * @param path the path value to set.
     * @return the ApiContractProperties object itself.
     */
    public ApiContractProperties withPath(String path) {
        this.path = path;
        return this;
    }

    /**
     * Get the protocols property: Describes on which protocols the operations in this API can be invoked.
     * 
     * @return the protocols value.
     */
    public List<Protocol> protocols() {
        return this.protocols;
    }

    /**
     * Set the protocols property: Describes on which protocols the operations in this API can be invoked.
     * 
     * @param protocols the protocols value to set.
     * @return the ApiContractProperties object itself.
     */
    public ApiContractProperties withProtocols(List<Protocol> protocols) {
        this.protocols = protocols;
        return this;
    }

    /**
     * Get the apiVersionSet property: Version set details.
     * 
     * @return the apiVersionSet value.
     */
    public ApiVersionSetContractDetails apiVersionSet() {
        return this.apiVersionSet;
    }

    /**
     * Set the apiVersionSet property: Version set details.
     * 
     * @param apiVersionSet the apiVersionSet value to set.
     * @return the ApiContractProperties object itself.
     */
    public ApiContractProperties withApiVersionSet(ApiVersionSetContractDetails apiVersionSet) {
        this.apiVersionSet = apiVersionSet;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState property: The provisioning state.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the ApiContractProperties object itself.
     */
    ApiContractProperties withProvisioningState(String provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Get the isOnline property: Indicates if API revision is accessible via the gateway.
     * 
     * @return the isOnline value.
     */
    @Override
    public Boolean isOnline() {
        return this.isOnline;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiContractProperties withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiContractProperties withAuthenticationSettings(AuthenticationSettingsContract authenticationSettings) {
        super.withAuthenticationSettings(authenticationSettings);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiContractProperties
        withSubscriptionKeyParameterNames(SubscriptionKeyParameterNamesContract subscriptionKeyParameterNames) {
        super.withSubscriptionKeyParameterNames(subscriptionKeyParameterNames);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiContractProperties withApiType(ApiType apiType) {
        super.withApiType(apiType);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiContractProperties withApiRevision(String apiRevision) {
        super.withApiRevision(apiRevision);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiContractProperties withApiVersion(String apiVersion) {
        super.withApiVersion(apiVersion);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiContractProperties withIsCurrent(Boolean isCurrent) {
        super.withIsCurrent(isCurrent);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiContractProperties withApiRevisionDescription(String apiRevisionDescription) {
        super.withApiRevisionDescription(apiRevisionDescription);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiContractProperties withApiVersionDescription(String apiVersionDescription) {
        super.withApiVersionDescription(apiVersionDescription);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiContractProperties withApiVersionSetId(String apiVersionSetId) {
        super.withApiVersionSetId(apiVersionSetId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiContractProperties withSubscriptionRequired(Boolean subscriptionRequired) {
        super.withSubscriptionRequired(subscriptionRequired);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiContractProperties withTermsOfServiceUrl(String termsOfServiceUrl) {
        super.withTermsOfServiceUrl(termsOfServiceUrl);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiContractProperties withContact(ApiContactInformation contact) {
        super.withContact(contact);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiContractProperties withLicense(ApiLicenseInformation license) {
        super.withLicense(license);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (path() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property path in model ApiContractProperties"));
        }
        if (apiVersionSet() != null) {
            apiVersionSet().validate();
        }
        if (authenticationSettings() != null) {
            authenticationSettings().validate();
        }
        if (subscriptionKeyParameterNames() != null) {
            subscriptionKeyParameterNames().validate();
        }
        if (contact() != null) {
            contact().validate();
        }
        if (license() != null) {
            license().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ApiContractProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", description());
        jsonWriter.writeJsonField("authenticationSettings", authenticationSettings());
        jsonWriter.writeJsonField("subscriptionKeyParameterNames", subscriptionKeyParameterNames());
        jsonWriter.writeStringField("type", apiType() == null ? null : apiType().toString());
        jsonWriter.writeStringField("apiRevision", apiRevision());
        jsonWriter.writeStringField("apiVersion", apiVersion());
        jsonWriter.writeBooleanField("isCurrent", isCurrent());
        jsonWriter.writeStringField("apiRevisionDescription", apiRevisionDescription());
        jsonWriter.writeStringField("apiVersionDescription", apiVersionDescription());
        jsonWriter.writeStringField("apiVersionSetId", apiVersionSetId());
        jsonWriter.writeBooleanField("subscriptionRequired", subscriptionRequired());
        jsonWriter.writeStringField("termsOfServiceUrl", termsOfServiceUrl());
        jsonWriter.writeJsonField("contact", contact());
        jsonWriter.writeJsonField("license", license());
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeStringField("sourceApiId", this.sourceApiId);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("serviceUrl", this.serviceUrl);
        jsonWriter.writeArrayField("protocols", this.protocols,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeJsonField("apiVersionSet", this.apiVersionSet);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiContractProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApiContractProperties.
     */
    public static ApiContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiContractProperties deserializedApiContractProperties = new ApiContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedApiContractProperties.withDescription(reader.getString());
                } else if ("authenticationSettings".equals(fieldName)) {
                    deserializedApiContractProperties
                        .withAuthenticationSettings(AuthenticationSettingsContract.fromJson(reader));
                } else if ("subscriptionKeyParameterNames".equals(fieldName)) {
                    deserializedApiContractProperties
                        .withSubscriptionKeyParameterNames(SubscriptionKeyParameterNamesContract.fromJson(reader));
                } else if ("type".equals(fieldName)) {
                    deserializedApiContractProperties.withApiType(ApiType.fromString(reader.getString()));
                } else if ("apiRevision".equals(fieldName)) {
                    deserializedApiContractProperties.withApiRevision(reader.getString());
                } else if ("apiVersion".equals(fieldName)) {
                    deserializedApiContractProperties.withApiVersion(reader.getString());
                } else if ("isCurrent".equals(fieldName)) {
                    deserializedApiContractProperties.withIsCurrent(reader.getNullable(JsonReader::getBoolean));
                } else if ("isOnline".equals(fieldName)) {
                    deserializedApiContractProperties.isOnline = reader.getNullable(JsonReader::getBoolean);
                } else if ("apiRevisionDescription".equals(fieldName)) {
                    deserializedApiContractProperties.withApiRevisionDescription(reader.getString());
                } else if ("apiVersionDescription".equals(fieldName)) {
                    deserializedApiContractProperties.withApiVersionDescription(reader.getString());
                } else if ("apiVersionSetId".equals(fieldName)) {
                    deserializedApiContractProperties.withApiVersionSetId(reader.getString());
                } else if ("subscriptionRequired".equals(fieldName)) {
                    deserializedApiContractProperties
                        .withSubscriptionRequired(reader.getNullable(JsonReader::getBoolean));
                } else if ("termsOfServiceUrl".equals(fieldName)) {
                    deserializedApiContractProperties.withTermsOfServiceUrl(reader.getString());
                } else if ("contact".equals(fieldName)) {
                    deserializedApiContractProperties.withContact(ApiContactInformation.fromJson(reader));
                } else if ("license".equals(fieldName)) {
                    deserializedApiContractProperties.withLicense(ApiLicenseInformation.fromJson(reader));
                } else if ("path".equals(fieldName)) {
                    deserializedApiContractProperties.path = reader.getString();
                } else if ("sourceApiId".equals(fieldName)) {
                    deserializedApiContractProperties.sourceApiId = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedApiContractProperties.displayName = reader.getString();
                } else if ("serviceUrl".equals(fieldName)) {
                    deserializedApiContractProperties.serviceUrl = reader.getString();
                } else if ("protocols".equals(fieldName)) {
                    List<Protocol> protocols = reader.readArray(reader1 -> Protocol.fromString(reader1.getString()));
                    deserializedApiContractProperties.protocols = protocols;
                } else if ("apiVersionSet".equals(fieldName)) {
                    deserializedApiContractProperties.apiVersionSet = ApiVersionSetContractDetails.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedApiContractProperties.provisioningState = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiContractProperties;
        });
    }
}
