// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ApiExportResultValue;
import com.azure.resourcemanager.apimanagement.models.ExportResultFormat;
import java.io.IOException;

/**
 * API Export result.
 */
@Fluent
public final class ApiExportResultInner implements JsonSerializable<ApiExportResultInner> {
    /*
     * ResourceId of the API which was exported.
     */
    private String id;

    /*
     * Format in which the API Details are exported to the Storage Blob with Sas Key valid for 5 minutes.
     */
    private ExportResultFormat exportResultFormat;

    /*
     * The object defining the schema of the exported API Detail
     */
    private ApiExportResultValue value;

    /**
     * Creates an instance of ApiExportResultInner class.
     */
    public ApiExportResultInner() {
    }

    /**
     * Get the id property: ResourceId of the API which was exported.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: ResourceId of the API which was exported.
     * 
     * @param id the id value to set.
     * @return the ApiExportResultInner object itself.
     */
    public ApiExportResultInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the exportResultFormat property: Format in which the API Details are exported to the Storage Blob with Sas
     * Key valid for 5 minutes.
     * 
     * @return the exportResultFormat value.
     */
    public ExportResultFormat exportResultFormat() {
        return this.exportResultFormat;
    }

    /**
     * Set the exportResultFormat property: Format in which the API Details are exported to the Storage Blob with Sas
     * Key valid for 5 minutes.
     * 
     * @param exportResultFormat the exportResultFormat value to set.
     * @return the ApiExportResultInner object itself.
     */
    public ApiExportResultInner withExportResultFormat(ExportResultFormat exportResultFormat) {
        this.exportResultFormat = exportResultFormat;
        return this;
    }

    /**
     * Get the value property: The object defining the schema of the exported API Detail.
     * 
     * @return the value value.
     */
    public ApiExportResultValue value() {
        return this.value;
    }

    /**
     * Set the value property: The object defining the schema of the exported API Detail.
     * 
     * @param value the value value to set.
     * @return the ApiExportResultInner object itself.
     */
    public ApiExportResultInner withValue(ApiExportResultValue value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("format",
            this.exportResultFormat == null ? null : this.exportResultFormat.toString());
        jsonWriter.writeJsonField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiExportResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiExportResultInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiExportResultInner.
     */
    public static ApiExportResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiExportResultInner deserializedApiExportResultInner = new ApiExportResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApiExportResultInner.id = reader.getString();
                } else if ("format".equals(fieldName)) {
                    deserializedApiExportResultInner.exportResultFormat
                        = ExportResultFormat.fromString(reader.getString());
                } else if ("value".equals(fieldName)) {
                    deserializedApiExportResultInner.value = ApiExportResultValue.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiExportResultInner;
        });
    }
}
