// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A single API Management gateway resource in List or Get response.
 */
@Fluent
public final class ApiManagementGatewayConfigConnectionResourceInner extends ProxyResource {
    /*
     * Properties of the API Management gateway config connection.
     */
    private GatewayConfigConnectionBaseProperties innerProperties = new GatewayConfigConnectionBaseProperties();

    /*
     * ETag of the resource.
     */
    private String etag;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ApiManagementGatewayConfigConnectionResourceInner class.
     */
    public ApiManagementGatewayConfigConnectionResourceInner() {
    }

    /**
     * Get the innerProperties property: Properties of the API Management gateway config connection.
     * 
     * @return the innerProperties value.
     */
    private GatewayConfigConnectionBaseProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: ETag of the resource.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the provisioningState property: The current provisioning state of the API Management gateway config
     * connection.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the sourceId property: The link to the API Management service workspace.
     * 
     * @return the sourceId value.
     */
    public String sourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceId();
    }

    /**
     * Set the sourceId property: The link to the API Management service workspace.
     * 
     * @param sourceId the sourceId value to set.
     * @return the ApiManagementGatewayConfigConnectionResourceInner object itself.
     */
    public ApiManagementGatewayConfigConnectionResourceInner withSourceId(String sourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GatewayConfigConnectionBaseProperties();
        }
        this.innerProperties().withSourceId(sourceId);
        return this;
    }

    /**
     * Get the defaultHostname property: The default hostname of the data-plane gateway.
     * 
     * @return the defaultHostname value.
     */
    public String defaultHostname() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultHostname();
    }

    /**
     * Get the hostnames property: The hostnames of the data-plane gateway to which requests can be sent.
     * 
     * @return the hostnames value.
     */
    public List<String> hostnames() {
        return this.innerProperties() == null ? null : this.innerProperties().hostnames();
    }

    /**
     * Set the hostnames property: The hostnames of the data-plane gateway to which requests can be sent.
     * 
     * @param hostnames the hostnames value to set.
     * @return the ApiManagementGatewayConfigConnectionResourceInner object itself.
     */
    public ApiManagementGatewayConfigConnectionResourceInner withHostnames(List<String> hostnames) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GatewayConfigConnectionBaseProperties();
        }
        this.innerProperties().withHostnames(hostnames);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerProperties in model ApiManagementGatewayConfigConnectionResourceInner"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER
        = new ClientLogger(ApiManagementGatewayConfigConnectionResourceInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementGatewayConfigConnectionResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementGatewayConfigConnectionResourceInner if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApiManagementGatewayConfigConnectionResourceInner.
     */
    public static ApiManagementGatewayConfigConnectionResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementGatewayConfigConnectionResourceInner deserializedApiManagementGatewayConfigConnectionResourceInner
                = new ApiManagementGatewayConfigConnectionResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApiManagementGatewayConfigConnectionResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedApiManagementGatewayConfigConnectionResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedApiManagementGatewayConfigConnectionResourceInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedApiManagementGatewayConfigConnectionResourceInner.innerProperties
                        = GatewayConfigConnectionBaseProperties.fromJson(reader);
                } else if ("etag".equals(fieldName)) {
                    deserializedApiManagementGatewayConfigConnectionResourceInner.etag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiManagementGatewayConfigConnectionResourceInner;
        });
    }
}
