// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewaySkuProperties;
import com.azure.resourcemanager.apimanagement.models.ApimResource;
import com.azure.resourcemanager.apimanagement.models.BackendConfiguration;
import com.azure.resourcemanager.apimanagement.models.FrontendConfiguration;
import com.azure.resourcemanager.apimanagement.models.GatewayConfigurationApi;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

/**
 * A single API Management gateway resource in List or Get response.
 */
@Fluent
public final class ApiManagementGatewayResourceInner extends ApimResource {
    /*
     * Properties of the API Management gateway.
     */
    private ApiManagementGatewayProperties innerProperties = new ApiManagementGatewayProperties();

    /*
     * SKU properties of the API Management gateway.
     */
    private ApiManagementGatewaySkuProperties sku;

    /*
     * Metadata pertaining to creation and last modification of the resource.
     */
    private SystemData systemData;

    /*
     * Resource location.
     */
    private String location;

    /*
     * ETag of the resource.
     */
    private String etag;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ApiManagementGatewayResourceInner class.
     */
    public ApiManagementGatewayResourceInner() {
    }

    /**
     * Get the innerProperties property: Properties of the API Management gateway.
     * 
     * @return the innerProperties value.
     */
    private ApiManagementGatewayProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the sku property: SKU properties of the API Management gateway.
     * 
     * @return the sku value.
     */
    public ApiManagementGatewaySkuProperties sku() {
        return this.sku;
    }

    /**
     * Set the sku property: SKU properties of the API Management gateway.
     * 
     * @param sku the sku value to set.
     * @return the ApiManagementGatewayResourceInner object itself.
     */
    public ApiManagementGatewayResourceInner withSku(ApiManagementGatewaySkuProperties sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the systemData property: Metadata pertaining to creation and last modification of the resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the location property: Resource location.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: Resource location.
     * 
     * @param location the location value to set.
     * @return the ApiManagementGatewayResourceInner object itself.
     */
    public ApiManagementGatewayResourceInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the etag property: ETag of the resource.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiManagementGatewayResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the provisioningState property: The current provisioning state of the API Management gateway which can be one
     * of the following: Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the targetProvisioningState property: The provisioning state of the API Management gateway, which is targeted
     * by the long running operation started on the gateway.
     * 
     * @return the targetProvisioningState value.
     */
    public String targetProvisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().targetProvisioningState();
    }

    /**
     * Get the createdAtUtc property: Creation UTC date of the API Management gateway.The date conforms to the following
     * format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the createdAtUtc value.
     */
    public OffsetDateTime createdAtUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().createdAtUtc();
    }

    /**
     * Get the frontend property: Information regarding how the gateway should be exposed.
     * 
     * @return the frontend value.
     */
    public FrontendConfiguration frontend() {
        return this.innerProperties() == null ? null : this.innerProperties().frontend();
    }

    /**
     * Set the frontend property: Information regarding how the gateway should be exposed.
     * 
     * @param frontend the frontend value to set.
     * @return the ApiManagementGatewayResourceInner object itself.
     */
    public ApiManagementGatewayResourceInner withFrontend(FrontendConfiguration frontend) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementGatewayProperties();
        }
        this.innerProperties().withFrontend(frontend);
        return this;
    }

    /**
     * Get the backend property: Information regarding how the gateway should integrate with backend systems.
     * 
     * @return the backend value.
     */
    public BackendConfiguration backend() {
        return this.innerProperties() == null ? null : this.innerProperties().backend();
    }

    /**
     * Set the backend property: Information regarding how the gateway should integrate with backend systems.
     * 
     * @param backend the backend value to set.
     * @return the ApiManagementGatewayResourceInner object itself.
     */
    public ApiManagementGatewayResourceInner withBackend(BackendConfiguration backend) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementGatewayProperties();
        }
        this.innerProperties().withBackend(backend);
        return this;
    }

    /**
     * Get the configurationApi property: Information regarding the Configuration API of the API Management gateway.
     * This is only applicable for API gateway with Standard SKU.
     * 
     * @return the configurationApi value.
     */
    public GatewayConfigurationApi configurationApi() {
        return this.innerProperties() == null ? null : this.innerProperties().configurationApi();
    }

    /**
     * Set the configurationApi property: Information regarding the Configuration API of the API Management gateway.
     * This is only applicable for API gateway with Standard SKU.
     * 
     * @param configurationApi the configurationApi value to set.
     * @return the ApiManagementGatewayResourceInner object itself.
     */
    public ApiManagementGatewayResourceInner withConfigurationApi(GatewayConfigurationApi configurationApi) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementGatewayProperties();
        }
        this.innerProperties().withConfigurationApi(configurationApi);
        return this;
    }

    /**
     * Get the virtualNetworkType property: The type of VPN in which API Management gateway needs to be configured in.
     * 
     * @return the virtualNetworkType value.
     */
    public VirtualNetworkType virtualNetworkType() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkType();
    }

    /**
     * Set the virtualNetworkType property: The type of VPN in which API Management gateway needs to be configured in.
     * 
     * @param virtualNetworkType the virtualNetworkType value to set.
     * @return the ApiManagementGatewayResourceInner object itself.
     */
    public ApiManagementGatewayResourceInner withVirtualNetworkType(VirtualNetworkType virtualNetworkType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementGatewayProperties();
        }
        this.innerProperties().withVirtualNetworkType(virtualNetworkType);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerProperties in model ApiManagementGatewayResourceInner"));
        } else {
            innerProperties().validate();
        }
        if (sku() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property sku in model ApiManagementGatewayResourceInner"));
        } else {
            sku().validate();
        }
        if (location() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property location in model ApiManagementGatewayResourceInner"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementGatewayResourceInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeStringField("location", this.location);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementGatewayResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementGatewayResourceInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApiManagementGatewayResourceInner.
     */
    public static ApiManagementGatewayResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementGatewayResourceInner deserializedApiManagementGatewayResourceInner
                = new ApiManagementGatewayResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApiManagementGatewayResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedApiManagementGatewayResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedApiManagementGatewayResourceInner.type = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedApiManagementGatewayResourceInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedApiManagementGatewayResourceInner.innerProperties
                        = ApiManagementGatewayProperties.fromJson(reader);
                } else if ("sku".equals(fieldName)) {
                    deserializedApiManagementGatewayResourceInner.sku
                        = ApiManagementGatewaySkuProperties.fromJson(reader);
                } else if ("location".equals(fieldName)) {
                    deserializedApiManagementGatewayResourceInner.location = reader.getString();
                } else if ("systemData".equals(fieldName)) {
                    deserializedApiManagementGatewayResourceInner.systemData = SystemData.fromJson(reader);
                } else if ("etag".equals(fieldName)) {
                    deserializedApiManagementGatewayResourceInner.etag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiManagementGatewayResourceInner;
        });
    }
}
