// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewayBaseProperties;
import com.azure.resourcemanager.apimanagement.models.BackendConfiguration;
import com.azure.resourcemanager.apimanagement.models.FrontendConfiguration;
import com.azure.resourcemanager.apimanagement.models.GatewayConfigurationApi;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkType;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Properties of an API Management gateway resource description.
 */
@Fluent
public final class ApiManagementGatewayUpdateProperties extends ApiManagementGatewayBaseProperties {
    /*
     * Creation UTC date of the API Management gateway.The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ`
     * as specified by the ISO 8601 standard.
     */
    private OffsetDateTime createdAtUtc;

    /*
     * The provisioning state of the API Management gateway, which is targeted by the long running operation started on
     * the gateway.
     */
    private String targetProvisioningState;

    /*
     * The current provisioning state of the API Management gateway which can be one of the following:
     * Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
     */
    private String provisioningState;

    /**
     * Creates an instance of ApiManagementGatewayUpdateProperties class.
     */
    public ApiManagementGatewayUpdateProperties() {
    }

    /**
     * Get the createdAtUtc property: Creation UTC date of the API Management gateway.The date conforms to the following
     * format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the createdAtUtc value.
     */
    @Override
    public OffsetDateTime createdAtUtc() {
        return this.createdAtUtc;
    }

    /**
     * Get the targetProvisioningState property: The provisioning state of the API Management gateway, which is targeted
     * by the long running operation started on the gateway.
     * 
     * @return the targetProvisioningState value.
     */
    @Override
    public String targetProvisioningState() {
        return this.targetProvisioningState;
    }

    /**
     * Get the provisioningState property: The current provisioning state of the API Management gateway which can be one
     * of the following: Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
     * 
     * @return the provisioningState value.
     */
    @Override
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiManagementGatewayUpdateProperties withFrontend(FrontendConfiguration frontend) {
        super.withFrontend(frontend);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiManagementGatewayUpdateProperties withBackend(BackendConfiguration backend) {
        super.withBackend(backend);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiManagementGatewayUpdateProperties withConfigurationApi(GatewayConfigurationApi configurationApi) {
        super.withConfigurationApi(configurationApi);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiManagementGatewayUpdateProperties withVirtualNetworkType(VirtualNetworkType virtualNetworkType) {
        super.withVirtualNetworkType(virtualNetworkType);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (frontend() != null) {
            frontend().validate();
        }
        if (backend() != null) {
            backend().validate();
        }
        if (configurationApi() != null) {
            configurationApi().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("frontend", frontend());
        jsonWriter.writeJsonField("backend", backend());
        jsonWriter.writeJsonField("configurationApi", configurationApi());
        jsonWriter.writeStringField("virtualNetworkType",
            virtualNetworkType() == null ? null : virtualNetworkType().toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementGatewayUpdateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementGatewayUpdateProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiManagementGatewayUpdateProperties.
     */
    public static ApiManagementGatewayUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementGatewayUpdateProperties deserializedApiManagementGatewayUpdateProperties
                = new ApiManagementGatewayUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateProperties.provisioningState = reader.getString();
                } else if ("targetProvisioningState".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateProperties.targetProvisioningState = reader.getString();
                } else if ("createdAtUtc".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateProperties.createdAtUtc = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("frontend".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateProperties
                        .withFrontend(FrontendConfiguration.fromJson(reader));
                } else if ("backend".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateProperties.withBackend(BackendConfiguration.fromJson(reader));
                } else if ("configurationApi".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateProperties
                        .withConfigurationApi(GatewayConfigurationApi.fromJson(reader));
                } else if ("virtualNetworkType".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateProperties
                        .withVirtualNetworkType(VirtualNetworkType.fromString(reader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiManagementGatewayUpdateProperties;
        });
    }
}
