// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The response of the GetSsoToken operation.
 */
@Fluent
public final class ApiManagementServiceGetSsoTokenResultInner
    implements JsonSerializable<ApiManagementServiceGetSsoTokenResultInner> {
    /*
     * Redirect URL to the Publisher Portal containing the SSO token.
     */
    private String redirectUri;

    /**
     * Creates an instance of ApiManagementServiceGetSsoTokenResultInner class.
     */
    public ApiManagementServiceGetSsoTokenResultInner() {
    }

    /**
     * Get the redirectUri property: Redirect URL to the Publisher Portal containing the SSO token.
     * 
     * @return the redirectUri value.
     */
    public String redirectUri() {
        return this.redirectUri;
    }

    /**
     * Set the redirectUri property: Redirect URL to the Publisher Portal containing the SSO token.
     * 
     * @param redirectUri the redirectUri value to set.
     * @return the ApiManagementServiceGetSsoTokenResultInner object itself.
     */
    public ApiManagementServiceGetSsoTokenResultInner withRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("redirectUri", this.redirectUri);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementServiceGetSsoTokenResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementServiceGetSsoTokenResultInner if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiManagementServiceGetSsoTokenResultInner.
     */
    public static ApiManagementServiceGetSsoTokenResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementServiceGetSsoTokenResultInner deserializedApiManagementServiceGetSsoTokenResultInner
                = new ApiManagementServiceGetSsoTokenResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("redirectUri".equals(fieldName)) {
                    deserializedApiManagementServiceGetSsoTokenResultInner.redirectUri = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiManagementServiceGetSsoTokenResultInner;
        });
    }
}
