// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.NameAvailabilityReason;
import java.io.IOException;

/**
 * Response of the CheckNameAvailability operation.
 */
@Fluent
public final class ApiManagementServiceNameAvailabilityResultInner
    implements JsonSerializable<ApiManagementServiceNameAvailabilityResultInner> {
    /*
     * True if the name is available and can be used to create a new API Management service; otherwise false.
     */
    private Boolean nameAvailable;

    /*
     * If reason == invalid, provide the user with the reason why the given name is invalid, and provide the resource
     * naming requirements so that the user can select a valid name. If reason == AlreadyExists, explain that
     * <resourceName> is already in use, and direct them to select a different name.
     */
    private String message;

    /*
     * Invalid indicates the name provided does not match the resource provider’s naming requirements (incorrect length,
     * unsupported characters, etc.) AlreadyExists indicates that the name is already in use and is therefore
     * unavailable.
     */
    private NameAvailabilityReason reason;

    /**
     * Creates an instance of ApiManagementServiceNameAvailabilityResultInner class.
     */
    public ApiManagementServiceNameAvailabilityResultInner() {
    }

    /**
     * Get the nameAvailable property: True if the name is available and can be used to create a new API Management
     * service; otherwise false.
     * 
     * @return the nameAvailable value.
     */
    public Boolean nameAvailable() {
        return this.nameAvailable;
    }

    /**
     * Get the message property: If reason == invalid, provide the user with the reason why the given name is invalid,
     * and provide the resource naming requirements so that the user can select a valid name. If reason ==
     * AlreadyExists, explain that &lt;resourceName&gt; is already in use, and direct them to select a different name.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Get the reason property: Invalid indicates the name provided does not match the resource provider’s naming
     * requirements (incorrect length, unsupported characters, etc.) AlreadyExists indicates that the name is already in
     * use and is therefore unavailable.
     * 
     * @return the reason value.
     */
    public NameAvailabilityReason reason() {
        return this.reason;
    }

    /**
     * Set the reason property: Invalid indicates the name provided does not match the resource provider’s naming
     * requirements (incorrect length, unsupported characters, etc.) AlreadyExists indicates that the name is already in
     * use and is therefore unavailable.
     * 
     * @param reason the reason value to set.
     * @return the ApiManagementServiceNameAvailabilityResultInner object itself.
     */
    public ApiManagementServiceNameAvailabilityResultInner withReason(NameAvailabilityReason reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason == null ? null : this.reason.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementServiceNameAvailabilityResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementServiceNameAvailabilityResultInner if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiManagementServiceNameAvailabilityResultInner.
     */
    public static ApiManagementServiceNameAvailabilityResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementServiceNameAvailabilityResultInner deserializedApiManagementServiceNameAvailabilityResultInner
                = new ApiManagementServiceNameAvailabilityResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("nameAvailable".equals(fieldName)) {
                    deserializedApiManagementServiceNameAvailabilityResultInner.nameAvailable
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("message".equals(fieldName)) {
                    deserializedApiManagementServiceNameAvailabilityResultInner.message = reader.getString();
                } else if ("reason".equals(fieldName)) {
                    deserializedApiManagementServiceNameAvailabilityResultInner.reason
                        = NameAvailabilityReason.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiManagementServiceNameAvailabilityResultInner;
        });
    }
}
