// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.AdditionalLocation;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceIdentity;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceSkuProperties;
import com.azure.resourcemanager.apimanagement.models.ApiVersionConstraint;
import com.azure.resourcemanager.apimanagement.models.ApimResource;
import com.azure.resourcemanager.apimanagement.models.CertificateConfiguration;
import com.azure.resourcemanager.apimanagement.models.ConfigurationApi;
import com.azure.resourcemanager.apimanagement.models.DeveloperPortalStatus;
import com.azure.resourcemanager.apimanagement.models.HostnameConfiguration;
import com.azure.resourcemanager.apimanagement.models.LegacyPortalStatus;
import com.azure.resourcemanager.apimanagement.models.NatGatewayState;
import com.azure.resourcemanager.apimanagement.models.PlatformVersion;
import com.azure.resourcemanager.apimanagement.models.PublicNetworkAccess;
import com.azure.resourcemanager.apimanagement.models.RemotePrivateEndpointConnectionWrapper;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkConfiguration;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/**
 * A single API Management service resource in List or Get response.
 */
@Fluent
public final class ApiManagementServiceResourceInner extends ApimResource {
    /*
     * Properties of the API Management service.
     */
    private ApiManagementServiceProperties innerProperties = new ApiManagementServiceProperties();

    /*
     * SKU properties of the API Management service.
     */
    private ApiManagementServiceSkuProperties sku;

    /*
     * Managed service identity of the Api Management service.
     */
    private ApiManagementServiceIdentity identity;

    /*
     * Metadata pertaining to creation and last modification of the resource.
     */
    private SystemData systemData;

    /*
     * Resource location.
     */
    private String location;

    /*
     * ETag of the resource.
     */
    private String etag;

    /*
     * A list of availability zones denoting where the resource needs to come from.
     */
    private List<String> zones;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ApiManagementServiceResourceInner class.
     */
    public ApiManagementServiceResourceInner() {
    }

    /**
     * Get the innerProperties property: Properties of the API Management service.
     * 
     * @return the innerProperties value.
     */
    private ApiManagementServiceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the sku property: SKU properties of the API Management service.
     * 
     * @return the sku value.
     */
    public ApiManagementServiceSkuProperties sku() {
        return this.sku;
    }

    /**
     * Set the sku property: SKU properties of the API Management service.
     * 
     * @param sku the sku value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner withSku(ApiManagementServiceSkuProperties sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the identity property: Managed service identity of the Api Management service.
     * 
     * @return the identity value.
     */
    public ApiManagementServiceIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Managed service identity of the Api Management service.
     * 
     * @param identity the identity value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner withIdentity(ApiManagementServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the systemData property: Metadata pertaining to creation and last modification of the resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the location property: Resource location.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: Resource location.
     * 
     * @param location the location value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the etag property: ETag of the resource.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the zones property: A list of availability zones denoting where the resource needs to come from.
     * 
     * @return the zones value.
     */
    public List<String> zones() {
        return this.zones;
    }

    /**
     * Set the zones property: A list of availability zones denoting where the resource needs to come from.
     * 
     * @param zones the zones value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiManagementServiceResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the publisherEmail property: Publisher email.
     * 
     * @return the publisherEmail value.
     */
    public String publisherEmail() {
        return this.innerProperties() == null ? null : this.innerProperties().publisherEmail();
    }

    /**
     * Set the publisherEmail property: Publisher email.
     * 
     * @param publisherEmail the publisherEmail value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner withPublisherEmail(String publisherEmail) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withPublisherEmail(publisherEmail);
        return this;
    }

    /**
     * Get the publisherName property: Publisher name.
     * 
     * @return the publisherName value.
     */
    public String publisherName() {
        return this.innerProperties() == null ? null : this.innerProperties().publisherName();
    }

    /**
     * Set the publisherName property: Publisher name.
     * 
     * @param publisherName the publisherName value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner withPublisherName(String publisherName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withPublisherName(publisherName);
        return this;
    }

    /**
     * Get the notificationSenderEmail property: Email address from which the notification will be sent.
     * 
     * @return the notificationSenderEmail value.
     */
    public String notificationSenderEmail() {
        return this.innerProperties() == null ? null : this.innerProperties().notificationSenderEmail();
    }

    /**
     * Set the notificationSenderEmail property: Email address from which the notification will be sent.
     * 
     * @param notificationSenderEmail the notificationSenderEmail value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner withNotificationSenderEmail(String notificationSenderEmail) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withNotificationSenderEmail(notificationSenderEmail);
        return this;
    }

    /**
     * Get the provisioningState property: The current provisioning state of the API Management service which can be one
     * of the following: Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the targetProvisioningState property: The provisioning state of the API Management service, which is targeted
     * by the long running operation started on the service.
     * 
     * @return the targetProvisioningState value.
     */
    public String targetProvisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().targetProvisioningState();
    }

    /**
     * Get the createdAtUtc property: Creation UTC date of the API Management service.The date conforms to the following
     * format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the createdAtUtc value.
     */
    public OffsetDateTime createdAtUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().createdAtUtc();
    }

    /**
     * Get the gatewayUrl property: Gateway URL of the API Management service.
     * 
     * @return the gatewayUrl value.
     */
    public String gatewayUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().gatewayUrl();
    }

    /**
     * Get the gatewayRegionalUrl property: Gateway URL of the API Management service in the Default Region.
     * 
     * @return the gatewayRegionalUrl value.
     */
    public String gatewayRegionalUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().gatewayRegionalUrl();
    }

    /**
     * Get the portalUrl property: Publisher portal endpoint Url of the API Management service.
     * 
     * @return the portalUrl value.
     */
    public String portalUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().portalUrl();
    }

    /**
     * Get the managementApiUrl property: Management API endpoint URL of the API Management service.
     * 
     * @return the managementApiUrl value.
     */
    public String managementApiUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().managementApiUrl();
    }

    /**
     * Get the scmUrl property: SCM endpoint URL of the API Management service.
     * 
     * @return the scmUrl value.
     */
    public String scmUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().scmUrl();
    }

    /**
     * Get the developerPortalUrl property: DEveloper Portal endpoint URL of the API Management service.
     * 
     * @return the developerPortalUrl value.
     */
    public String developerPortalUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().developerPortalUrl();
    }

    /**
     * Get the hostnameConfigurations property: Custom hostname configuration of the API Management service.
     * 
     * @return the hostnameConfigurations value.
     */
    public List<HostnameConfiguration> hostnameConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().hostnameConfigurations();
    }

    /**
     * Set the hostnameConfigurations property: Custom hostname configuration of the API Management service.
     * 
     * @param hostnameConfigurations the hostnameConfigurations value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner
        withHostnameConfigurations(List<HostnameConfiguration> hostnameConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withHostnameConfigurations(hostnameConfigurations);
        return this;
    }

    /**
     * Get the publicIpAddresses property: Public Static Load Balanced IP addresses of the API Management service in
     * Primary region. Available only for Basic, Standard, Premium and Isolated SKU.
     * 
     * @return the publicIpAddresses value.
     */
    public List<String> publicIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpAddresses();
    }

    /**
     * Get the privateIpAddresses property: Private Static Load Balanced IP addresses of the API Management service in
     * Primary region which is deployed in an Internal Virtual Network. Available only for Basic, Standard, Premium and
     * Isolated SKU.
     * 
     * @return the privateIpAddresses value.
     */
    public List<String> privateIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().privateIpAddresses();
    }

    /**
     * Get the publicIpAddressId property: Public Standard SKU IP V4 based IP address to be associated with Virtual
     * Network deployed service in the region. Supported only for Developer and Premium SKU being deployed in Virtual
     * Network.
     * 
     * @return the publicIpAddressId value.
     */
    public String publicIpAddressId() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpAddressId();
    }

    /**
     * Set the publicIpAddressId property: Public Standard SKU IP V4 based IP address to be associated with Virtual
     * Network deployed service in the region. Supported only for Developer and Premium SKU being deployed in Virtual
     * Network.
     * 
     * @param publicIpAddressId the publicIpAddressId value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner withPublicIpAddressId(String publicIpAddressId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withPublicIpAddressId(publicIpAddressId);
        return this;
    }

    /**
     * Get the publicNetworkAccess property: Whether or not public endpoint access is allowed for this API Management
     * service. Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints
     * are the exclusive access method. Default value is 'Enabled'.
     * 
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    /**
     * Set the publicNetworkAccess property: Whether or not public endpoint access is allowed for this API Management
     * service. Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints
     * are the exclusive access method. Default value is 'Enabled'.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    /**
     * Get the configurationApi property: Configuration API configuration of the API Management service.
     * 
     * @return the configurationApi value.
     */
    public ConfigurationApi configurationApi() {
        return this.innerProperties() == null ? null : this.innerProperties().configurationApi();
    }

    /**
     * Set the configurationApi property: Configuration API configuration of the API Management service.
     * 
     * @param configurationApi the configurationApi value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner withConfigurationApi(ConfigurationApi configurationApi) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withConfigurationApi(configurationApi);
        return this;
    }

    /**
     * Get the virtualNetworkConfiguration property: Virtual network configuration of the API Management service.
     * 
     * @return the virtualNetworkConfiguration value.
     */
    public VirtualNetworkConfiguration virtualNetworkConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkConfiguration();
    }

    /**
     * Set the virtualNetworkConfiguration property: Virtual network configuration of the API Management service.
     * 
     * @param virtualNetworkConfiguration the virtualNetworkConfiguration value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner
        withVirtualNetworkConfiguration(VirtualNetworkConfiguration virtualNetworkConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withVirtualNetworkConfiguration(virtualNetworkConfiguration);
        return this;
    }

    /**
     * Get the additionalLocations property: Additional datacenter locations of the API Management service.
     * 
     * @return the additionalLocations value.
     */
    public List<AdditionalLocation> additionalLocations() {
        return this.innerProperties() == null ? null : this.innerProperties().additionalLocations();
    }

    /**
     * Set the additionalLocations property: Additional datacenter locations of the API Management service.
     * 
     * @param additionalLocations the additionalLocations value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner withAdditionalLocations(List<AdditionalLocation> additionalLocations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withAdditionalLocations(additionalLocations);
        return this;
    }

    /**
     * Get the customProperties property: Custom properties of the API Management service.&lt;/br&gt;Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168` will disable the cipher
     * TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).&lt;/br&gt;Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11` can be used to disable just TLS
     * 1.1.&lt;/br&gt;Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10` can be used to
     * disable TLS 1.0 on an API Management service.&lt;/br&gt;Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11` can be used to disable just TLS
     * 1.1 for communications with backends.&lt;/br&gt;Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10` can be used to disable TLS 1.0
     * for communications with backends.&lt;/br&gt;Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2` can be used to enable HTTP2 protocol on an
     * API Management service.&lt;/br&gt;Not specifying any of these properties on PATCH operation will reset omitted
     * properties' values to their defaults. For all the settings except Http2 the default value is `True` if the
     * service was created on or before April 1, 2018 and `False` otherwise. Http2 setting's default value is
     * `False`.&lt;/br&gt;&lt;/br&gt;You can disable any of the following ciphers by using settings
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`:
     * TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA,
     * TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256,
     * TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA. For example,
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:`false`. The
     * default value is `true` for them.&lt;/br&gt; Note: The following ciphers can't be disabled since they are
     * required by internal platform components:
     * TLS_AES_256_GCM_SHA384,TLS_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256.
     * 
     * @return the customProperties value.
     */
    public Map<String, String> customProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().customProperties();
    }

    /**
     * Set the customProperties property: Custom properties of the API Management service.&lt;/br&gt;Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168` will disable the cipher
     * TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).&lt;/br&gt;Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11` can be used to disable just TLS
     * 1.1.&lt;/br&gt;Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10` can be used to
     * disable TLS 1.0 on an API Management service.&lt;/br&gt;Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11` can be used to disable just TLS
     * 1.1 for communications with backends.&lt;/br&gt;Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10` can be used to disable TLS 1.0
     * for communications with backends.&lt;/br&gt;Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2` can be used to enable HTTP2 protocol on an
     * API Management service.&lt;/br&gt;Not specifying any of these properties on PATCH operation will reset omitted
     * properties' values to their defaults. For all the settings except Http2 the default value is `True` if the
     * service was created on or before April 1, 2018 and `False` otherwise. Http2 setting's default value is
     * `False`.&lt;/br&gt;&lt;/br&gt;You can disable any of the following ciphers by using settings
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`:
     * TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA,
     * TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256,
     * TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA. For example,
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:`false`. The
     * default value is `true` for them.&lt;/br&gt; Note: The following ciphers can't be disabled since they are
     * required by internal platform components:
     * TLS_AES_256_GCM_SHA384,TLS_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256.
     * 
     * @param customProperties the customProperties value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner withCustomProperties(Map<String, String> customProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withCustomProperties(customProperties);
        return this;
    }

    /**
     * Get the certificates property: List of Certificates that need to be installed in the API Management service. Max
     * supported certificates that can be installed is 10.
     * 
     * @return the certificates value.
     */
    public List<CertificateConfiguration> certificates() {
        return this.innerProperties() == null ? null : this.innerProperties().certificates();
    }

    /**
     * Set the certificates property: List of Certificates that need to be installed in the API Management service. Max
     * supported certificates that can be installed is 10.
     * 
     * @param certificates the certificates value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner withCertificates(List<CertificateConfiguration> certificates) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withCertificates(certificates);
        return this;
    }

    /**
     * Get the enableClientCertificate property: Property only meant to be used for Consumption SKU Service. This
     * enforces a client certificate to be presented on each request to the gateway. This also enables the ability to
     * authenticate the certificate in the policy on the gateway.
     * 
     * @return the enableClientCertificate value.
     */
    public Boolean enableClientCertificate() {
        return this.innerProperties() == null ? null : this.innerProperties().enableClientCertificate();
    }

    /**
     * Set the enableClientCertificate property: Property only meant to be used for Consumption SKU Service. This
     * enforces a client certificate to be presented on each request to the gateway. This also enables the ability to
     * authenticate the certificate in the policy on the gateway.
     * 
     * @param enableClientCertificate the enableClientCertificate value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner withEnableClientCertificate(Boolean enableClientCertificate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withEnableClientCertificate(enableClientCertificate);
        return this;
    }

    /**
     * Get the natGatewayState property: Property can be used to enable NAT Gateway for this API Management service.
     * 
     * @return the natGatewayState value.
     */
    public NatGatewayState natGatewayState() {
        return this.innerProperties() == null ? null : this.innerProperties().natGatewayState();
    }

    /**
     * Set the natGatewayState property: Property can be used to enable NAT Gateway for this API Management service.
     * 
     * @param natGatewayState the natGatewayState value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner withNatGatewayState(NatGatewayState natGatewayState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withNatGatewayState(natGatewayState);
        return this;
    }

    /**
     * Get the outboundPublicIpAddresses property: Outbound public IPV4 address prefixes associated with NAT Gateway
     * deployed service. Available only for Premium SKU on stv2 platform.
     * 
     * @return the outboundPublicIpAddresses value.
     */
    public List<String> outboundPublicIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().outboundPublicIpAddresses();
    }

    /**
     * Get the disableGateway property: Property only valid for an Api Management service deployed in multiple
     * locations. This can be used to disable the gateway in master region.
     * 
     * @return the disableGateway value.
     */
    public Boolean disableGateway() {
        return this.innerProperties() == null ? null : this.innerProperties().disableGateway();
    }

    /**
     * Set the disableGateway property: Property only valid for an Api Management service deployed in multiple
     * locations. This can be used to disable the gateway in master region.
     * 
     * @param disableGateway the disableGateway value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner withDisableGateway(Boolean disableGateway) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withDisableGateway(disableGateway);
        return this;
    }

    /**
     * Get the virtualNetworkType property: The type of VPN in which API Management service needs to be configured in.
     * None (Default Value) means the API Management service is not part of any Virtual Network, External means the API
     * Management deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means
     * that API Management deployment is setup inside a Virtual Network having an Intranet Facing Endpoint only.
     * 
     * @return the virtualNetworkType value.
     */
    public VirtualNetworkType virtualNetworkType() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkType();
    }

    /**
     * Set the virtualNetworkType property: The type of VPN in which API Management service needs to be configured in.
     * None (Default Value) means the API Management service is not part of any Virtual Network, External means the API
     * Management deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means
     * that API Management deployment is setup inside a Virtual Network having an Intranet Facing Endpoint only.
     * 
     * @param virtualNetworkType the virtualNetworkType value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner withVirtualNetworkType(VirtualNetworkType virtualNetworkType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withVirtualNetworkType(virtualNetworkType);
        return this;
    }

    /**
     * Get the apiVersionConstraint property: Control Plane Apis version constraint for the API Management service.
     * 
     * @return the apiVersionConstraint value.
     */
    public ApiVersionConstraint apiVersionConstraint() {
        return this.innerProperties() == null ? null : this.innerProperties().apiVersionConstraint();
    }

    /**
     * Set the apiVersionConstraint property: Control Plane Apis version constraint for the API Management service.
     * 
     * @param apiVersionConstraint the apiVersionConstraint value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner withApiVersionConstraint(ApiVersionConstraint apiVersionConstraint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withApiVersionConstraint(apiVersionConstraint);
        return this;
    }

    /**
     * Get the restore property: Undelete Api Management Service if it was previously soft-deleted. If this flag is
     * specified and set to True all other properties will be ignored.
     * 
     * @return the restore value.
     */
    public Boolean restore() {
        return this.innerProperties() == null ? null : this.innerProperties().restore();
    }

    /**
     * Set the restore property: Undelete Api Management Service if it was previously soft-deleted. If this flag is
     * specified and set to True all other properties will be ignored.
     * 
     * @param restore the restore value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner withRestore(Boolean restore) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withRestore(restore);
        return this;
    }

    /**
     * Get the privateEndpointConnections property: List of Private Endpoint Connections of this service.
     * 
     * @return the privateEndpointConnections value.
     */
    public List<RemotePrivateEndpointConnectionWrapper> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    /**
     * Set the privateEndpointConnections property: List of Private Endpoint Connections of this service.
     * 
     * @param privateEndpointConnections the privateEndpointConnections value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner
        withPrivateEndpointConnections(List<RemotePrivateEndpointConnectionWrapper> privateEndpointConnections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withPrivateEndpointConnections(privateEndpointConnections);
        return this;
    }

    /**
     * Get the platformVersion property: Compute Platform Version running the service in this location.
     * 
     * @return the platformVersion value.
     */
    public PlatformVersion platformVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().platformVersion();
    }

    /**
     * Get the legacyPortalStatus property: Status of legacy portal in the API Management service.
     * 
     * @return the legacyPortalStatus value.
     */
    public LegacyPortalStatus legacyPortalStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().legacyPortalStatus();
    }

    /**
     * Set the legacyPortalStatus property: Status of legacy portal in the API Management service.
     * 
     * @param legacyPortalStatus the legacyPortalStatus value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner withLegacyPortalStatus(LegacyPortalStatus legacyPortalStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withLegacyPortalStatus(legacyPortalStatus);
        return this;
    }

    /**
     * Get the developerPortalStatus property: Status of developer portal in this API Management service.
     * 
     * @return the developerPortalStatus value.
     */
    public DeveloperPortalStatus developerPortalStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().developerPortalStatus();
    }

    /**
     * Set the developerPortalStatus property: Status of developer portal in this API Management service.
     * 
     * @param developerPortalStatus the developerPortalStatus value to set.
     * @return the ApiManagementServiceResourceInner object itself.
     */
    public ApiManagementServiceResourceInner withDeveloperPortalStatus(DeveloperPortalStatus developerPortalStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withDeveloperPortalStatus(developerPortalStatus);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerProperties in model ApiManagementServiceResourceInner"));
        } else {
            innerProperties().validate();
        }
        if (sku() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property sku in model ApiManagementServiceResourceInner"));
        } else {
            sku().validate();
        }
        if (identity() != null) {
            identity().validate();
        }
        if (location() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property location in model ApiManagementServiceResourceInner"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementServiceResourceInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementServiceResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementServiceResourceInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApiManagementServiceResourceInner.
     */
    public static ApiManagementServiceResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementServiceResourceInner deserializedApiManagementServiceResourceInner
                = new ApiManagementServiceResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApiManagementServiceResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedApiManagementServiceResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedApiManagementServiceResourceInner.type = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedApiManagementServiceResourceInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedApiManagementServiceResourceInner.innerProperties
                        = ApiManagementServiceProperties.fromJson(reader);
                } else if ("sku".equals(fieldName)) {
                    deserializedApiManagementServiceResourceInner.sku
                        = ApiManagementServiceSkuProperties.fromJson(reader);
                } else if ("location".equals(fieldName)) {
                    deserializedApiManagementServiceResourceInner.location = reader.getString();
                } else if ("identity".equals(fieldName)) {
                    deserializedApiManagementServiceResourceInner.identity
                        = ApiManagementServiceIdentity.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedApiManagementServiceResourceInner.systemData = SystemData.fromJson(reader);
                } else if ("etag".equals(fieldName)) {
                    deserializedApiManagementServiceResourceInner.etag = reader.getString();
                } else if ("zones".equals(fieldName)) {
                    List<String> zones = reader.readArray(reader1 -> reader1.getString());
                    deserializedApiManagementServiceResourceInner.zones = zones;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiManagementServiceResourceInner;
        });
    }
}
