// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.WorkspaceLinksBaseProperties;
import com.azure.resourcemanager.apimanagement.models.WorkspaceLinksGateway;
import java.io.IOException;
import java.util.List;

/**
 * Properties of an API Management workspaceLinks resource.
 */
@Fluent
public final class ApiManagementWorkspaceLinksProperties extends WorkspaceLinksBaseProperties {
    /**
     * Creates an instance of ApiManagementWorkspaceLinksProperties class.
     */
    public ApiManagementWorkspaceLinksProperties() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiManagementWorkspaceLinksProperties withWorkspaceId(String workspaceId) {
        super.withWorkspaceId(workspaceId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiManagementWorkspaceLinksProperties withGateways(List<WorkspaceLinksGateway> gateways) {
        super.withGateways(gateways);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (gateways() != null) {
            gateways().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("workspaceId", workspaceId());
        jsonWriter.writeArrayField("gateways", gateways(), (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementWorkspaceLinksProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementWorkspaceLinksProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiManagementWorkspaceLinksProperties.
     */
    public static ApiManagementWorkspaceLinksProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementWorkspaceLinksProperties deserializedApiManagementWorkspaceLinksProperties
                = new ApiManagementWorkspaceLinksProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("workspaceId".equals(fieldName)) {
                    deserializedApiManagementWorkspaceLinksProperties.withWorkspaceId(reader.getString());
                } else if ("gateways".equals(fieldName)) {
                    List<WorkspaceLinksGateway> gateways
                        = reader.readArray(reader1 -> WorkspaceLinksGateway.fromJson(reader1));
                    deserializedApiManagementWorkspaceLinksProperties.withGateways(gateways);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiManagementWorkspaceLinksProperties;
        });
    }
}
