// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.WorkspaceLinksGateway;
import java.io.IOException;
import java.util.List;

/**
 * A single API Management WorkspaceLinks in List or Get response.
 */
@Fluent
public final class ApiManagementWorkspaceLinksResourceInner extends ProxyResource {
    /*
     * Properties of the API Management WorkspaceLinks.
     */
    private ApiManagementWorkspaceLinksProperties innerProperties = new ApiManagementWorkspaceLinksProperties();

    /*
     * ETag of the resource.
     */
    private String etag;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ApiManagementWorkspaceLinksResourceInner class.
     */
    public ApiManagementWorkspaceLinksResourceInner() {
    }

    /**
     * Get the innerProperties property: Properties of the API Management WorkspaceLinks.
     * 
     * @return the innerProperties value.
     */
    private ApiManagementWorkspaceLinksProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: ETag of the resource.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the workspaceId property: The link to the API Management service workspace.
     * 
     * @return the workspaceId value.
     */
    public String workspaceId() {
        return this.innerProperties() == null ? null : this.innerProperties().workspaceId();
    }

    /**
     * Set the workspaceId property: The link to the API Management service workspace.
     * 
     * @param workspaceId the workspaceId value to set.
     * @return the ApiManagementWorkspaceLinksResourceInner object itself.
     */
    public ApiManagementWorkspaceLinksResourceInner withWorkspaceId(String workspaceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementWorkspaceLinksProperties();
        }
        this.innerProperties().withWorkspaceId(workspaceId);
        return this;
    }

    /**
     * Get the gateways property: The array of linked gateways.
     * 
     * @return the gateways value.
     */
    public List<WorkspaceLinksGateway> gateways() {
        return this.innerProperties() == null ? null : this.innerProperties().gateways();
    }

    /**
     * Set the gateways property: The array of linked gateways.
     * 
     * @param gateways the gateways value to set.
     * @return the ApiManagementWorkspaceLinksResourceInner object itself.
     */
    public ApiManagementWorkspaceLinksResourceInner withGateways(List<WorkspaceLinksGateway> gateways) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementWorkspaceLinksProperties();
        }
        this.innerProperties().withGateways(gateways);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerProperties in model ApiManagementWorkspaceLinksResourceInner"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementWorkspaceLinksResourceInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementWorkspaceLinksResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementWorkspaceLinksResourceInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApiManagementWorkspaceLinksResourceInner.
     */
    public static ApiManagementWorkspaceLinksResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementWorkspaceLinksResourceInner deserializedApiManagementWorkspaceLinksResourceInner
                = new ApiManagementWorkspaceLinksResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApiManagementWorkspaceLinksResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedApiManagementWorkspaceLinksResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedApiManagementWorkspaceLinksResourceInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedApiManagementWorkspaceLinksResourceInner.innerProperties
                        = ApiManagementWorkspaceLinksProperties.fromJson(reader);
                } else if ("etag".equals(fieldName)) {
                    deserializedApiManagementWorkspaceLinksResourceInner.etag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiManagementWorkspaceLinksResourceInner;
        });
    }
}
