// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * ApiRelease details.
 */
@Fluent
public final class ApiReleaseContractInner extends ProxyResource {
    /*
     * ApiRelease entity contract properties.
     */
    private ApiReleaseContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ApiReleaseContractInner class.
     */
    public ApiReleaseContractInner() {
    }

    /**
     * Get the innerProperties property: ApiRelease entity contract properties.
     * 
     * @return the innerProperties value.
     */
    private ApiReleaseContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the apiId property: Identifier of the API the release belongs to.
     * 
     * @return the apiId value.
     */
    public String apiId() {
        return this.innerProperties() == null ? null : this.innerProperties().apiId();
    }

    /**
     * Set the apiId property: Identifier of the API the release belongs to.
     * 
     * @param apiId the apiId value to set.
     * @return the ApiReleaseContractInner object itself.
     */
    public ApiReleaseContractInner withApiId(String apiId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiReleaseContractProperties();
        }
        this.innerProperties().withApiId(apiId);
        return this;
    }

    /**
     * Get the createdDateTime property: The time the API was released. The date conforms to the following format:
     * yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
     * 
     * @return the createdDateTime value.
     */
    public OffsetDateTime createdDateTime() {
        return this.innerProperties() == null ? null : this.innerProperties().createdDateTime();
    }

    /**
     * Get the updatedDateTime property: The time the API release was updated.
     * 
     * @return the updatedDateTime value.
     */
    public OffsetDateTime updatedDateTime() {
        return this.innerProperties() == null ? null : this.innerProperties().updatedDateTime();
    }

    /**
     * Get the notes property: Release Notes.
     * 
     * @return the notes value.
     */
    public String notes() {
        return this.innerProperties() == null ? null : this.innerProperties().notes();
    }

    /**
     * Set the notes property: Release Notes.
     * 
     * @param notes the notes value to set.
     * @return the ApiReleaseContractInner object itself.
     */
    public ApiReleaseContractInner withNotes(String notes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiReleaseContractProperties();
        }
        this.innerProperties().withNotes(notes);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiReleaseContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiReleaseContractInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApiReleaseContractInner.
     */
    public static ApiReleaseContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiReleaseContractInner deserializedApiReleaseContractInner = new ApiReleaseContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApiReleaseContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedApiReleaseContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedApiReleaseContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedApiReleaseContractInner.innerProperties = ApiReleaseContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiReleaseContractInner;
        });
    }
}
