// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * API Release details.
 */
@Fluent
public final class ApiReleaseContractProperties implements JsonSerializable<ApiReleaseContractProperties> {
    /*
     * Identifier of the API the release belongs to.
     */
    private String apiId;

    /*
     * The time the API was released. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by
     * the ISO 8601 standard.
     */
    private OffsetDateTime createdDateTime;

    /*
     * The time the API release was updated.
     */
    private OffsetDateTime updatedDateTime;

    /*
     * Release Notes
     */
    private String notes;

    /**
     * Creates an instance of ApiReleaseContractProperties class.
     */
    public ApiReleaseContractProperties() {
    }

    /**
     * Get the apiId property: Identifier of the API the release belongs to.
     * 
     * @return the apiId value.
     */
    public String apiId() {
        return this.apiId;
    }

    /**
     * Set the apiId property: Identifier of the API the release belongs to.
     * 
     * @param apiId the apiId value to set.
     * @return the ApiReleaseContractProperties object itself.
     */
    public ApiReleaseContractProperties withApiId(String apiId) {
        this.apiId = apiId;
        return this;
    }

    /**
     * Get the createdDateTime property: The time the API was released. The date conforms to the following format:
     * yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
     * 
     * @return the createdDateTime value.
     */
    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    /**
     * Get the updatedDateTime property: The time the API release was updated.
     * 
     * @return the updatedDateTime value.
     */
    public OffsetDateTime updatedDateTime() {
        return this.updatedDateTime;
    }

    /**
     * Get the notes property: Release Notes.
     * 
     * @return the notes value.
     */
    public String notes() {
        return this.notes;
    }

    /**
     * Set the notes property: Release Notes.
     * 
     * @param notes the notes value to set.
     * @return the ApiReleaseContractProperties object itself.
     */
    public ApiReleaseContractProperties withNotes(String notes) {
        this.notes = notes;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("apiId", this.apiId);
        jsonWriter.writeStringField("notes", this.notes);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiReleaseContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiReleaseContractProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiReleaseContractProperties.
     */
    public static ApiReleaseContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiReleaseContractProperties deserializedApiReleaseContractProperties = new ApiReleaseContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("apiId".equals(fieldName)) {
                    deserializedApiReleaseContractProperties.apiId = reader.getString();
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedApiReleaseContractProperties.createdDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("updatedDateTime".equals(fieldName)) {
                    deserializedApiReleaseContractProperties.updatedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("notes".equals(fieldName)) {
                    deserializedApiReleaseContractProperties.notes = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiReleaseContractProperties;
        });
    }
}
