// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.VersioningScheme;
import java.io.IOException;

/**
 * API Version Set Contract details.
 */
@Fluent
public final class ApiVersionSetContractInner extends ProxyResource {
    /*
     * API VersionSet contract properties.
     */
    private ApiVersionSetContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ApiVersionSetContractInner class.
     */
    public ApiVersionSetContractInner() {
    }

    /**
     * Get the innerProperties property: API VersionSet contract properties.
     * 
     * @return the innerProperties value.
     */
    private ApiVersionSetContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the displayName property: Name of API Version Set.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: Name of API Version Set.
     * 
     * @param displayName the displayName value to set.
     * @return the ApiVersionSetContractInner object itself.
     */
    public ApiVersionSetContractInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiVersionSetContractProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the versioningScheme property: An value that determines where the API Version identifier will be located in a
     * HTTP request.
     * 
     * @return the versioningScheme value.
     */
    public VersioningScheme versioningScheme() {
        return this.innerProperties() == null ? null : this.innerProperties().versioningScheme();
    }

    /**
     * Set the versioningScheme property: An value that determines where the API Version identifier will be located in a
     * HTTP request.
     * 
     * @param versioningScheme the versioningScheme value to set.
     * @return the ApiVersionSetContractInner object itself.
     */
    public ApiVersionSetContractInner withVersioningScheme(VersioningScheme versioningScheme) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiVersionSetContractProperties();
        }
        this.innerProperties().withVersioningScheme(versioningScheme);
        return this;
    }

    /**
     * Get the description property: Description of API Version Set.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Description of API Version Set.
     * 
     * @param description the description value to set.
     * @return the ApiVersionSetContractInner object itself.
     */
    public ApiVersionSetContractInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiVersionSetContractProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the versionQueryName property: Name of query parameter that indicates the API Version if versioningScheme is
     * set to `query`.
     * 
     * @return the versionQueryName value.
     */
    public String versionQueryName() {
        return this.innerProperties() == null ? null : this.innerProperties().versionQueryName();
    }

    /**
     * Set the versionQueryName property: Name of query parameter that indicates the API Version if versioningScheme is
     * set to `query`.
     * 
     * @param versionQueryName the versionQueryName value to set.
     * @return the ApiVersionSetContractInner object itself.
     */
    public ApiVersionSetContractInner withVersionQueryName(String versionQueryName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiVersionSetContractProperties();
        }
        this.innerProperties().withVersionQueryName(versionQueryName);
        return this;
    }

    /**
     * Get the versionHeaderName property: Name of HTTP header parameter that indicates the API Version if
     * versioningScheme is set to `header`.
     * 
     * @return the versionHeaderName value.
     */
    public String versionHeaderName() {
        return this.innerProperties() == null ? null : this.innerProperties().versionHeaderName();
    }

    /**
     * Set the versionHeaderName property: Name of HTTP header parameter that indicates the API Version if
     * versioningScheme is set to `header`.
     * 
     * @param versionHeaderName the versionHeaderName value to set.
     * @return the ApiVersionSetContractInner object itself.
     */
    public ApiVersionSetContractInner withVersionHeaderName(String versionHeaderName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiVersionSetContractProperties();
        }
        this.innerProperties().withVersionHeaderName(versionHeaderName);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiVersionSetContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiVersionSetContractInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApiVersionSetContractInner.
     */
    public static ApiVersionSetContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiVersionSetContractInner deserializedApiVersionSetContractInner = new ApiVersionSetContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApiVersionSetContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedApiVersionSetContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedApiVersionSetContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedApiVersionSetContractInner.innerProperties
                        = ApiVersionSetContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiVersionSetContractInner;
        });
    }
}
