// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ApiVersionSetEntityBase;
import com.azure.resourcemanager.apimanagement.models.VersioningScheme;
import java.io.IOException;

/**
 * Properties of an API Version Set.
 */
@Fluent
public final class ApiVersionSetContractProperties extends ApiVersionSetEntityBase {
    /*
     * Name of API Version Set
     */
    private String displayName;

    /*
     * An value that determines where the API Version identifier will be located in a HTTP request.
     */
    private VersioningScheme versioningScheme;

    /**
     * Creates an instance of ApiVersionSetContractProperties class.
     */
    public ApiVersionSetContractProperties() {
    }

    /**
     * Get the displayName property: Name of API Version Set.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Name of API Version Set.
     * 
     * @param displayName the displayName value to set.
     * @return the ApiVersionSetContractProperties object itself.
     */
    public ApiVersionSetContractProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the versioningScheme property: An value that determines where the API Version identifier will be located in a
     * HTTP request.
     * 
     * @return the versioningScheme value.
     */
    public VersioningScheme versioningScheme() {
        return this.versioningScheme;
    }

    /**
     * Set the versioningScheme property: An value that determines where the API Version identifier will be located in a
     * HTTP request.
     * 
     * @param versioningScheme the versioningScheme value to set.
     * @return the ApiVersionSetContractProperties object itself.
     */
    public ApiVersionSetContractProperties withVersioningScheme(VersioningScheme versioningScheme) {
        this.versioningScheme = versioningScheme;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiVersionSetContractProperties withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiVersionSetContractProperties withVersionQueryName(String versionQueryName) {
        super.withVersionQueryName(versionQueryName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiVersionSetContractProperties withVersionHeaderName(String versionHeaderName) {
        super.withVersionHeaderName(versionHeaderName);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (displayName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property displayName in model ApiVersionSetContractProperties"));
        }
        if (versioningScheme() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property versioningScheme in model ApiVersionSetContractProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ApiVersionSetContractProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", description());
        jsonWriter.writeStringField("versionQueryName", versionQueryName());
        jsonWriter.writeStringField("versionHeaderName", versionHeaderName());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("versioningScheme",
            this.versioningScheme == null ? null : this.versioningScheme.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiVersionSetContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiVersionSetContractProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApiVersionSetContractProperties.
     */
    public static ApiVersionSetContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiVersionSetContractProperties deserializedApiVersionSetContractProperties
                = new ApiVersionSetContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedApiVersionSetContractProperties.withDescription(reader.getString());
                } else if ("versionQueryName".equals(fieldName)) {
                    deserializedApiVersionSetContractProperties.withVersionQueryName(reader.getString());
                } else if ("versionHeaderName".equals(fieldName)) {
                    deserializedApiVersionSetContractProperties.withVersionHeaderName(reader.getString());
                } else if ("displayName".equals(fieldName)) {
                    deserializedApiVersionSetContractProperties.displayName = reader.getString();
                } else if ("versioningScheme".equals(fieldName)) {
                    deserializedApiVersionSetContractProperties.versioningScheme
                        = VersioningScheme.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiVersionSetContractProperties;
        });
    }
}
