// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Authorization access policy contract.
 */
@Fluent
public final class AuthorizationAccessPolicyContractInner extends ProxyResource {
    /*
     * Properties of the Authorization Contract.
     */
    private AuthorizationAccessPolicyContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of AuthorizationAccessPolicyContractInner class.
     */
    public AuthorizationAccessPolicyContractInner() {
    }

    /**
     * Get the innerProperties property: Properties of the Authorization Contract.
     * 
     * @return the innerProperties value.
     */
    private AuthorizationAccessPolicyContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the appIds property: The allowed Azure Active Directory Application IDs.
     * 
     * @return the appIds value.
     */
    public List<String> appIds() {
        return this.innerProperties() == null ? null : this.innerProperties().appIds();
    }

    /**
     * Set the appIds property: The allowed Azure Active Directory Application IDs.
     * 
     * @param appIds the appIds value to set.
     * @return the AuthorizationAccessPolicyContractInner object itself.
     */
    public AuthorizationAccessPolicyContractInner withAppIds(List<String> appIds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthorizationAccessPolicyContractProperties();
        }
        this.innerProperties().withAppIds(appIds);
        return this;
    }

    /**
     * Get the tenantId property: The Tenant Id.
     * 
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantId();
    }

    /**
     * Set the tenantId property: The Tenant Id.
     * 
     * @param tenantId the tenantId value to set.
     * @return the AuthorizationAccessPolicyContractInner object itself.
     */
    public AuthorizationAccessPolicyContractInner withTenantId(String tenantId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthorizationAccessPolicyContractProperties();
        }
        this.innerProperties().withTenantId(tenantId);
        return this;
    }

    /**
     * Get the objectId property: The Object Id.
     * 
     * @return the objectId value.
     */
    public String objectId() {
        return this.innerProperties() == null ? null : this.innerProperties().objectId();
    }

    /**
     * Set the objectId property: The Object Id.
     * 
     * @param objectId the objectId value to set.
     * @return the AuthorizationAccessPolicyContractInner object itself.
     */
    public AuthorizationAccessPolicyContractInner withObjectId(String objectId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthorizationAccessPolicyContractProperties();
        }
        this.innerProperties().withObjectId(objectId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AuthorizationAccessPolicyContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AuthorizationAccessPolicyContractInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AuthorizationAccessPolicyContractInner.
     */
    public static AuthorizationAccessPolicyContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AuthorizationAccessPolicyContractInner deserializedAuthorizationAccessPolicyContractInner
                = new AuthorizationAccessPolicyContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAuthorizationAccessPolicyContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedAuthorizationAccessPolicyContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedAuthorizationAccessPolicyContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedAuthorizationAccessPolicyContractInner.innerProperties
                        = AuthorizationAccessPolicyContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAuthorizationAccessPolicyContractInner;
        });
    }
}
