// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Authorization Access Policy details.
 */
@Fluent
public final class AuthorizationAccessPolicyContractProperties
    implements JsonSerializable<AuthorizationAccessPolicyContractProperties> {
    /*
     * The allowed Azure Active Directory Application IDs
     */
    private List<String> appIds;

    /*
     * The Tenant Id
     */
    private String tenantId;

    /*
     * The Object Id
     */
    private String objectId;

    /**
     * Creates an instance of AuthorizationAccessPolicyContractProperties class.
     */
    public AuthorizationAccessPolicyContractProperties() {
    }

    /**
     * Get the appIds property: The allowed Azure Active Directory Application IDs.
     * 
     * @return the appIds value.
     */
    public List<String> appIds() {
        return this.appIds;
    }

    /**
     * Set the appIds property: The allowed Azure Active Directory Application IDs.
     * 
     * @param appIds the appIds value to set.
     * @return the AuthorizationAccessPolicyContractProperties object itself.
     */
    public AuthorizationAccessPolicyContractProperties withAppIds(List<String> appIds) {
        this.appIds = appIds;
        return this;
    }

    /**
     * Get the tenantId property: The Tenant Id.
     * 
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Set the tenantId property: The Tenant Id.
     * 
     * @param tenantId the tenantId value to set.
     * @return the AuthorizationAccessPolicyContractProperties object itself.
     */
    public AuthorizationAccessPolicyContractProperties withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * Get the objectId property: The Object Id.
     * 
     * @return the objectId value.
     */
    public String objectId() {
        return this.objectId;
    }

    /**
     * Set the objectId property: The Object Id.
     * 
     * @param objectId the objectId value to set.
     * @return the AuthorizationAccessPolicyContractProperties object itself.
     */
    public AuthorizationAccessPolicyContractProperties withObjectId(String objectId) {
        this.objectId = objectId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("appIds", this.appIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("tenantId", this.tenantId);
        jsonWriter.writeStringField("objectId", this.objectId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AuthorizationAccessPolicyContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AuthorizationAccessPolicyContractProperties if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AuthorizationAccessPolicyContractProperties.
     */
    public static AuthorizationAccessPolicyContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AuthorizationAccessPolicyContractProperties deserializedAuthorizationAccessPolicyContractProperties
                = new AuthorizationAccessPolicyContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("appIds".equals(fieldName)) {
                    List<String> appIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedAuthorizationAccessPolicyContractProperties.appIds = appIds;
                } else if ("tenantId".equals(fieldName)) {
                    deserializedAuthorizationAccessPolicyContractProperties.tenantId = reader.getString();
                } else if ("objectId".equals(fieldName)) {
                    deserializedAuthorizationAccessPolicyContractProperties.objectId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAuthorizationAccessPolicyContractProperties;
        });
    }
}
