// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.AuthorizationError;
import com.azure.resourcemanager.apimanagement.models.AuthorizationType;
import com.azure.resourcemanager.apimanagement.models.OAuth2GrantType;
import java.io.IOException;
import java.util.Map;

/**
 * Authorization contract.
 */
@Fluent
public final class AuthorizationContractInner extends ProxyResource {
    /*
     * Properties of the Authorization Contract.
     */
    private AuthorizationContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of AuthorizationContractInner class.
     */
    public AuthorizationContractInner() {
    }

    /**
     * Get the innerProperties property: Properties of the Authorization Contract.
     * 
     * @return the innerProperties value.
     */
    private AuthorizationContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the authorizationType property: Authorization type options.
     * 
     * @return the authorizationType value.
     */
    public AuthorizationType authorizationType() {
        return this.innerProperties() == null ? null : this.innerProperties().authorizationType();
    }

    /**
     * Set the authorizationType property: Authorization type options.
     * 
     * @param authorizationType the authorizationType value to set.
     * @return the AuthorizationContractInner object itself.
     */
    public AuthorizationContractInner withAuthorizationType(AuthorizationType authorizationType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthorizationContractProperties();
        }
        this.innerProperties().withAuthorizationType(authorizationType);
        return this;
    }

    /**
     * Get the oAuth2GrantType property: OAuth2 grant type options.
     * 
     * @return the oAuth2GrantType value.
     */
    public OAuth2GrantType oAuth2GrantType() {
        return this.innerProperties() == null ? null : this.innerProperties().oAuth2GrantType();
    }

    /**
     * Set the oAuth2GrantType property: OAuth2 grant type options.
     * 
     * @param oAuth2GrantType the oAuth2GrantType value to set.
     * @return the AuthorizationContractInner object itself.
     */
    public AuthorizationContractInner withOAuth2GrantType(OAuth2GrantType oAuth2GrantType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthorizationContractProperties();
        }
        this.innerProperties().withOAuth2GrantType(oAuth2GrantType);
        return this;
    }

    /**
     * Get the parameters property: Authorization parameters.
     * 
     * @return the parameters value.
     */
    public Map<String, String> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    /**
     * Set the parameters property: Authorization parameters.
     * 
     * @param parameters the parameters value to set.
     * @return the AuthorizationContractInner object itself.
     */
    public AuthorizationContractInner withParameters(Map<String, String> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthorizationContractProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    /**
     * Get the error property: Authorization error details.
     * 
     * @return the error value.
     */
    public AuthorizationError error() {
        return this.innerProperties() == null ? null : this.innerProperties().error();
    }

    /**
     * Set the error property: Authorization error details.
     * 
     * @param error the error value to set.
     * @return the AuthorizationContractInner object itself.
     */
    public AuthorizationContractInner withError(AuthorizationError error) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthorizationContractProperties();
        }
        this.innerProperties().withError(error);
        return this;
    }

    /**
     * Get the status property: Status of the Authorization.
     * 
     * @return the status value.
     */
    public String status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Set the status property: Status of the Authorization.
     * 
     * @param status the status value to set.
     * @return the AuthorizationContractInner object itself.
     */
    public AuthorizationContractInner withStatus(String status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthorizationContractProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AuthorizationContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AuthorizationContractInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AuthorizationContractInner.
     */
    public static AuthorizationContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AuthorizationContractInner deserializedAuthorizationContractInner = new AuthorizationContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAuthorizationContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedAuthorizationContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedAuthorizationContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedAuthorizationContractInner.innerProperties
                        = AuthorizationContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAuthorizationContractInner;
        });
    }
}
