// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Authorization login response contract.
 */
@Fluent
public final class AuthorizationLoginResponseContractInner
    implements JsonSerializable<AuthorizationLoginResponseContractInner> {
    /*
     * The login link
     */
    private String loginLink;

    /**
     * Creates an instance of AuthorizationLoginResponseContractInner class.
     */
    public AuthorizationLoginResponseContractInner() {
    }

    /**
     * Get the loginLink property: The login link.
     * 
     * @return the loginLink value.
     */
    public String loginLink() {
        return this.loginLink;
    }

    /**
     * Set the loginLink property: The login link.
     * 
     * @param loginLink the loginLink value to set.
     * @return the AuthorizationLoginResponseContractInner object itself.
     */
    public AuthorizationLoginResponseContractInner withLoginLink(String loginLink) {
        this.loginLink = loginLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("loginLink", this.loginLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AuthorizationLoginResponseContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AuthorizationLoginResponseContractInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AuthorizationLoginResponseContractInner.
     */
    public static AuthorizationLoginResponseContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AuthorizationLoginResponseContractInner deserializedAuthorizationLoginResponseContractInner
                = new AuthorizationLoginResponseContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("loginLink".equals(fieldName)) {
                    deserializedAuthorizationLoginResponseContractInner.loginLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAuthorizationLoginResponseContractInner;
        });
    }
}
