// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * OAuth Server Secrets Contract.
 */
@Fluent
public final class AuthorizationServerSecretsContractInner
    implements JsonSerializable<AuthorizationServerSecretsContractInner> {
    /*
     * oAuth Authorization Server Secrets.
     */
    private String clientSecret;

    /*
     * Can be optionally specified when resource owner password grant type is supported by this authorization server.
     * Default resource owner username.
     */
    private String resourceOwnerUsername;

    /*
     * Can be optionally specified when resource owner password grant type is supported by this authorization server.
     * Default resource owner password.
     */
    private String resourceOwnerPassword;

    /**
     * Creates an instance of AuthorizationServerSecretsContractInner class.
     */
    public AuthorizationServerSecretsContractInner() {
    }

    /**
     * Get the clientSecret property: oAuth Authorization Server Secrets.
     * 
     * @return the clientSecret value.
     */
    public String clientSecret() {
        return this.clientSecret;
    }

    /**
     * Set the clientSecret property: oAuth Authorization Server Secrets.
     * 
     * @param clientSecret the clientSecret value to set.
     * @return the AuthorizationServerSecretsContractInner object itself.
     */
    public AuthorizationServerSecretsContractInner withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    /**
     * Get the resourceOwnerUsername property: Can be optionally specified when resource owner password grant type is
     * supported by this authorization server. Default resource owner username.
     * 
     * @return the resourceOwnerUsername value.
     */
    public String resourceOwnerUsername() {
        return this.resourceOwnerUsername;
    }

    /**
     * Set the resourceOwnerUsername property: Can be optionally specified when resource owner password grant type is
     * supported by this authorization server. Default resource owner username.
     * 
     * @param resourceOwnerUsername the resourceOwnerUsername value to set.
     * @return the AuthorizationServerSecretsContractInner object itself.
     */
    public AuthorizationServerSecretsContractInner withResourceOwnerUsername(String resourceOwnerUsername) {
        this.resourceOwnerUsername = resourceOwnerUsername;
        return this;
    }

    /**
     * Get the resourceOwnerPassword property: Can be optionally specified when resource owner password grant type is
     * supported by this authorization server. Default resource owner password.
     * 
     * @return the resourceOwnerPassword value.
     */
    public String resourceOwnerPassword() {
        return this.resourceOwnerPassword;
    }

    /**
     * Set the resourceOwnerPassword property: Can be optionally specified when resource owner password grant type is
     * supported by this authorization server. Default resource owner password.
     * 
     * @param resourceOwnerPassword the resourceOwnerPassword value to set.
     * @return the AuthorizationServerSecretsContractInner object itself.
     */
    public AuthorizationServerSecretsContractInner withResourceOwnerPassword(String resourceOwnerPassword) {
        this.resourceOwnerPassword = resourceOwnerPassword;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clientSecret", this.clientSecret);
        jsonWriter.writeStringField("resourceOwnerUsername", this.resourceOwnerUsername);
        jsonWriter.writeStringField("resourceOwnerPassword", this.resourceOwnerPassword);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AuthorizationServerSecretsContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AuthorizationServerSecretsContractInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AuthorizationServerSecretsContractInner.
     */
    public static AuthorizationServerSecretsContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AuthorizationServerSecretsContractInner deserializedAuthorizationServerSecretsContractInner
                = new AuthorizationServerSecretsContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("clientSecret".equals(fieldName)) {
                    deserializedAuthorizationServerSecretsContractInner.clientSecret = reader.getString();
                } else if ("resourceOwnerUsername".equals(fieldName)) {
                    deserializedAuthorizationServerSecretsContractInner.resourceOwnerUsername = reader.getString();
                } else if ("resourceOwnerPassword".equals(fieldName)) {
                    deserializedAuthorizationServerSecretsContractInner.resourceOwnerPassword = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAuthorizationServerSecretsContractInner;
        });
    }
}
