// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.BackendBaseParametersPool;
import com.azure.resourcemanager.apimanagement.models.BackendCircuitBreaker;
import com.azure.resourcemanager.apimanagement.models.BackendCredentialsContract;
import com.azure.resourcemanager.apimanagement.models.BackendProperties;
import com.azure.resourcemanager.apimanagement.models.BackendProtocol;
import com.azure.resourcemanager.apimanagement.models.BackendProxyContract;
import com.azure.resourcemanager.apimanagement.models.BackendTlsProperties;
import com.azure.resourcemanager.apimanagement.models.BackendType;
import java.io.IOException;

/**
 * Backend details.
 */
@Fluent
public final class BackendContractInner extends ProxyResource {
    /*
     * Backend entity contract properties.
     */
    private BackendContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of BackendContractInner class.
     */
    public BackendContractInner() {
    }

    /**
     * Get the innerProperties property: Backend entity contract properties.
     * 
     * @return the innerProperties value.
     */
    private BackendContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the url property: Runtime Url of the Backend.
     * 
     * @return the url value.
     */
    public String url() {
        return this.innerProperties() == null ? null : this.innerProperties().url();
    }

    /**
     * Set the url property: Runtime Url of the Backend.
     * 
     * @param url the url value to set.
     * @return the BackendContractInner object itself.
     */
    public BackendContractInner withUrl(String url) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendContractProperties();
        }
        this.innerProperties().withUrl(url);
        return this;
    }

    /**
     * Get the protocol property: Backend communication protocol.
     * 
     * @return the protocol value.
     */
    public BackendProtocol protocol() {
        return this.innerProperties() == null ? null : this.innerProperties().protocol();
    }

    /**
     * Set the protocol property: Backend communication protocol.
     * 
     * @param protocol the protocol value to set.
     * @return the BackendContractInner object itself.
     */
    public BackendContractInner withProtocol(BackendProtocol protocol) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendContractProperties();
        }
        this.innerProperties().withProtocol(protocol);
        return this;
    }

    /**
     * Get the title property: Backend Title.
     * 
     * @return the title value.
     */
    public String title() {
        return this.innerProperties() == null ? null : this.innerProperties().title();
    }

    /**
     * Set the title property: Backend Title.
     * 
     * @param title the title value to set.
     * @return the BackendContractInner object itself.
     */
    public BackendContractInner withTitle(String title) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendContractProperties();
        }
        this.innerProperties().withTitle(title);
        return this;
    }

    /**
     * Get the description property: Backend Description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Backend Description.
     * 
     * @param description the description value to set.
     * @return the BackendContractInner object itself.
     */
    public BackendContractInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendContractProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the resourceId property: Management Uri of the Resource in External System. This URL can be the Arm Resource
     * Id of Logic Apps, Function Apps or API Apps.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceId();
    }

    /**
     * Set the resourceId property: Management Uri of the Resource in External System. This URL can be the Arm Resource
     * Id of Logic Apps, Function Apps or API Apps.
     * 
     * @param resourceId the resourceId value to set.
     * @return the BackendContractInner object itself.
     */
    public BackendContractInner withResourceId(String resourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendContractProperties();
        }
        this.innerProperties().withResourceId(resourceId);
        return this;
    }

    /**
     * Get the properties property: Backend Properties contract.
     * 
     * @return the properties value.
     */
    public BackendProperties properties() {
        return this.innerProperties() == null ? null : this.innerProperties().properties();
    }

    /**
     * Set the properties property: Backend Properties contract.
     * 
     * @param properties the properties value to set.
     * @return the BackendContractInner object itself.
     */
    public BackendContractInner withProperties(BackendProperties properties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendContractProperties();
        }
        this.innerProperties().withProperties(properties);
        return this;
    }

    /**
     * Get the credentials property: Backend Credentials Contract Properties.
     * 
     * @return the credentials value.
     */
    public BackendCredentialsContract credentials() {
        return this.innerProperties() == null ? null : this.innerProperties().credentials();
    }

    /**
     * Set the credentials property: Backend Credentials Contract Properties.
     * 
     * @param credentials the credentials value to set.
     * @return the BackendContractInner object itself.
     */
    public BackendContractInner withCredentials(BackendCredentialsContract credentials) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendContractProperties();
        }
        this.innerProperties().withCredentials(credentials);
        return this;
    }

    /**
     * Get the proxy property: Backend gateway Contract Properties.
     * 
     * @return the proxy value.
     */
    public BackendProxyContract proxy() {
        return this.innerProperties() == null ? null : this.innerProperties().proxy();
    }

    /**
     * Set the proxy property: Backend gateway Contract Properties.
     * 
     * @param proxy the proxy value to set.
     * @return the BackendContractInner object itself.
     */
    public BackendContractInner withProxy(BackendProxyContract proxy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendContractProperties();
        }
        this.innerProperties().withProxy(proxy);
        return this;
    }

    /**
     * Get the tls property: Backend TLS Properties.
     * 
     * @return the tls value.
     */
    public BackendTlsProperties tls() {
        return this.innerProperties() == null ? null : this.innerProperties().tls();
    }

    /**
     * Set the tls property: Backend TLS Properties.
     * 
     * @param tls the tls value to set.
     * @return the BackendContractInner object itself.
     */
    public BackendContractInner withTls(BackendTlsProperties tls) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendContractProperties();
        }
        this.innerProperties().withTls(tls);
        return this;
    }

    /**
     * Get the circuitBreaker property: Backend Circuit Breaker Configuration.
     * 
     * @return the circuitBreaker value.
     */
    public BackendCircuitBreaker circuitBreaker() {
        return this.innerProperties() == null ? null : this.innerProperties().circuitBreaker();
    }

    /**
     * Set the circuitBreaker property: Backend Circuit Breaker Configuration.
     * 
     * @param circuitBreaker the circuitBreaker value to set.
     * @return the BackendContractInner object itself.
     */
    public BackendContractInner withCircuitBreaker(BackendCircuitBreaker circuitBreaker) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendContractProperties();
        }
        this.innerProperties().withCircuitBreaker(circuitBreaker);
        return this;
    }

    /**
     * Get the pool property: The pool property.
     * 
     * @return the pool value.
     */
    public BackendBaseParametersPool pool() {
        return this.innerProperties() == null ? null : this.innerProperties().pool();
    }

    /**
     * Set the pool property: The pool property.
     * 
     * @param pool the pool value to set.
     * @return the BackendContractInner object itself.
     */
    public BackendContractInner withPool(BackendBaseParametersPool pool) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendContractProperties();
        }
        this.innerProperties().withPool(pool);
        return this;
    }

    /**
     * Get the type property: Type of the backend. A backend can be either Single or Pool.
     * 
     * @return the type value.
     */
    public BackendType typePropertiesType() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    /**
     * Set the type property: Type of the backend. A backend can be either Single or Pool.
     * 
     * @param type the type value to set.
     * @return the BackendContractInner object itself.
     */
    public BackendContractInner withTypePropertiesType(BackendType type) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendContractProperties();
        }
        this.innerProperties().withType(type);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BackendContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BackendContractInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BackendContractInner.
     */
    public static BackendContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackendContractInner deserializedBackendContractInner = new BackendContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedBackendContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedBackendContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedBackendContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedBackendContractInner.innerProperties = BackendContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBackendContractInner;
        });
    }
}
