// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of the Cache contract.
 */
@Fluent
public final class CacheContractProperties implements JsonSerializable<CacheContractProperties> {
    /*
     * Cache description
     */
    private String description;

    /*
     * Runtime connection string to cache
     */
    private String connectionString;

    /*
     * Location identifier to use cache from (should be either 'default' or valid Azure region identifier)
     */
    private String useFromLocation;

    /*
     * Original uri of entity in external system cache points to
     */
    private String resourceId;

    /**
     * Creates an instance of CacheContractProperties class.
     */
    public CacheContractProperties() {
    }

    /**
     * Get the description property: Cache description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Cache description.
     * 
     * @param description the description value to set.
     * @return the CacheContractProperties object itself.
     */
    public CacheContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the connectionString property: Runtime connection string to cache.
     * 
     * @return the connectionString value.
     */
    public String connectionString() {
        return this.connectionString;
    }

    /**
     * Set the connectionString property: Runtime connection string to cache.
     * 
     * @param connectionString the connectionString value to set.
     * @return the CacheContractProperties object itself.
     */
    public CacheContractProperties withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    /**
     * Get the useFromLocation property: Location identifier to use cache from (should be either 'default' or valid
     * Azure region identifier).
     * 
     * @return the useFromLocation value.
     */
    public String useFromLocation() {
        return this.useFromLocation;
    }

    /**
     * Set the useFromLocation property: Location identifier to use cache from (should be either 'default' or valid
     * Azure region identifier).
     * 
     * @param useFromLocation the useFromLocation value to set.
     * @return the CacheContractProperties object itself.
     */
    public CacheContractProperties withUseFromLocation(String useFromLocation) {
        this.useFromLocation = useFromLocation;
        return this;
    }

    /**
     * Get the resourceId property: Original uri of entity in external system cache points to.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: Original uri of entity in external system cache points to.
     * 
     * @param resourceId the resourceId value to set.
     * @return the CacheContractProperties object itself.
     */
    public CacheContractProperties withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (connectionString() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property connectionString in model CacheContractProperties"));
        }
        if (useFromLocation() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property useFromLocation in model CacheContractProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CacheContractProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connectionString", this.connectionString);
        jsonWriter.writeStringField("useFromLocation", this.useFromLocation);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CacheContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CacheContractProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CacheContractProperties.
     */
    public static CacheContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CacheContractProperties deserializedCacheContractProperties = new CacheContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("connectionString".equals(fieldName)) {
                    deserializedCacheContractProperties.connectionString = reader.getString();
                } else if ("useFromLocation".equals(fieldName)) {
                    deserializedCacheContractProperties.useFromLocation = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedCacheContractProperties.description = reader.getString();
                } else if ("resourceId".equals(fieldName)) {
                    deserializedCacheContractProperties.resourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCacheContractProperties;
        });
    }
}
