// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameters supplied to the Update Cache operation.
 */
@Fluent
public final class CacheUpdateProperties implements JsonSerializable<CacheUpdateProperties> {
    /*
     * Cache description
     */
    private String description;

    /*
     * Runtime connection string to cache
     */
    private String connectionString;

    /*
     * Location identifier to use cache from (should be either 'default' or valid Azure region identifier)
     */
    private String useFromLocation;

    /*
     * Original uri of entity in external system cache points to
     */
    private String resourceId;

    /**
     * Creates an instance of CacheUpdateProperties class.
     */
    public CacheUpdateProperties() {
    }

    /**
     * Get the description property: Cache description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Cache description.
     * 
     * @param description the description value to set.
     * @return the CacheUpdateProperties object itself.
     */
    public CacheUpdateProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the connectionString property: Runtime connection string to cache.
     * 
     * @return the connectionString value.
     */
    public String connectionString() {
        return this.connectionString;
    }

    /**
     * Set the connectionString property: Runtime connection string to cache.
     * 
     * @param connectionString the connectionString value to set.
     * @return the CacheUpdateProperties object itself.
     */
    public CacheUpdateProperties withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    /**
     * Get the useFromLocation property: Location identifier to use cache from (should be either 'default' or valid
     * Azure region identifier).
     * 
     * @return the useFromLocation value.
     */
    public String useFromLocation() {
        return this.useFromLocation;
    }

    /**
     * Set the useFromLocation property: Location identifier to use cache from (should be either 'default' or valid
     * Azure region identifier).
     * 
     * @param useFromLocation the useFromLocation value to set.
     * @return the CacheUpdateProperties object itself.
     */
    public CacheUpdateProperties withUseFromLocation(String useFromLocation) {
        this.useFromLocation = useFromLocation;
        return this;
    }

    /**
     * Get the resourceId property: Original uri of entity in external system cache points to.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: Original uri of entity in external system cache points to.
     * 
     * @param resourceId the resourceId value to set.
     * @return the CacheUpdateProperties object itself.
     */
    public CacheUpdateProperties withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("connectionString", this.connectionString);
        jsonWriter.writeStringField("useFromLocation", this.useFromLocation);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CacheUpdateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CacheUpdateProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CacheUpdateProperties.
     */
    public static CacheUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CacheUpdateProperties deserializedCacheUpdateProperties = new CacheUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedCacheUpdateProperties.description = reader.getString();
                } else if ("connectionString".equals(fieldName)) {
                    deserializedCacheUpdateProperties.connectionString = reader.getString();
                } else if ("useFromLocation".equals(fieldName)) {
                    deserializedCacheUpdateProperties.useFromLocation = reader.getString();
                } else if ("resourceId".equals(fieldName)) {
                    deserializedCacheUpdateProperties.resourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCacheUpdateProperties;
        });
    }
}
