// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.KeyVaultContractCreateProperties;
import java.io.IOException;

/**
 * Parameters supplied to the CreateOrUpdate certificate operation.
 */
@Fluent
public final class CertificateCreateOrUpdateProperties
    implements JsonSerializable<CertificateCreateOrUpdateProperties> {
    /*
     * Base 64 encoded certificate using the application/x-pkcs12 representation.
     */
    private String data;

    /*
     * Password for the Certificate
     */
    private String password;

    /*
     * KeyVault location details of the certificate.
     */
    private KeyVaultContractCreateProperties keyVault;

    /**
     * Creates an instance of CertificateCreateOrUpdateProperties class.
     */
    public CertificateCreateOrUpdateProperties() {
    }

    /**
     * Get the data property: Base 64 encoded certificate using the application/x-pkcs12 representation.
     * 
     * @return the data value.
     */
    public String data() {
        return this.data;
    }

    /**
     * Set the data property: Base 64 encoded certificate using the application/x-pkcs12 representation.
     * 
     * @param data the data value to set.
     * @return the CertificateCreateOrUpdateProperties object itself.
     */
    public CertificateCreateOrUpdateProperties withData(String data) {
        this.data = data;
        return this;
    }

    /**
     * Get the password property: Password for the Certificate.
     * 
     * @return the password value.
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password property: Password for the Certificate.
     * 
     * @param password the password value to set.
     * @return the CertificateCreateOrUpdateProperties object itself.
     */
    public CertificateCreateOrUpdateProperties withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Get the keyVault property: KeyVault location details of the certificate.
     * 
     * @return the keyVault value.
     */
    public KeyVaultContractCreateProperties keyVault() {
        return this.keyVault;
    }

    /**
     * Set the keyVault property: KeyVault location details of the certificate.
     * 
     * @param keyVault the keyVault value to set.
     * @return the CertificateCreateOrUpdateProperties object itself.
     */
    public CertificateCreateOrUpdateProperties withKeyVault(KeyVaultContractCreateProperties keyVault) {
        this.keyVault = keyVault;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyVault() != null) {
            keyVault().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("data", this.data);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeJsonField("keyVault", this.keyVault);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateCreateOrUpdateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateCreateOrUpdateProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CertificateCreateOrUpdateProperties.
     */
    public static CertificateCreateOrUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificateCreateOrUpdateProperties deserializedCertificateCreateOrUpdateProperties
                = new CertificateCreateOrUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("data".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateProperties.data = reader.getString();
                } else if ("password".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateProperties.password = reader.getString();
                } else if ("keyVault".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateProperties.keyVault
                        = KeyVaultContractCreateProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificateCreateOrUpdateProperties;
        });
    }
}
