// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
 */
@Fluent
public final class ClientSecretContractInner implements JsonSerializable<ClientSecretContractInner> {
    /*
     * Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
     */
    private String clientSecret;

    /**
     * Creates an instance of ClientSecretContractInner class.
     */
    public ClientSecretContractInner() {
    }

    /**
     * Get the clientSecret property: Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
     * 
     * @return the clientSecret value.
     */
    public String clientSecret() {
        return this.clientSecret;
    }

    /**
     * Set the clientSecret property: Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
     * 
     * @param clientSecret the clientSecret value to set.
     * @return the ClientSecretContractInner object itself.
     */
    public ClientSecretContractInner withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clientSecret", this.clientSecret);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClientSecretContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClientSecretContractInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ClientSecretContractInner.
     */
    public static ClientSecretContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClientSecretContractInner deserializedClientSecretContractInner = new ClientSecretContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("clientSecret".equals(fieldName)) {
                    deserializedClientSecretContractInner.clientSecret = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedClientSecretContractInner;
        });
    }
}
