// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ConnectionStatus;
import com.azure.resourcemanager.apimanagement.models.ConnectivityHop;
import java.io.IOException;
import java.util.List;

/**
 * Information on the connectivity status.
 */
@Immutable
public final class ConnectivityCheckResponseInner implements JsonSerializable<ConnectivityCheckResponseInner> {
    /*
     * List of hops between the source and the destination.
     */
    private List<ConnectivityHop> hops;

    /*
     * The connection status.
     */
    private ConnectionStatus connectionStatus;

    /*
     * Average latency in milliseconds.
     */
    private Long avgLatencyInMs;

    /*
     * Minimum latency in milliseconds.
     */
    private Long minLatencyInMs;

    /*
     * Maximum latency in milliseconds.
     */
    private Long maxLatencyInMs;

    /*
     * Total number of probes sent.
     */
    private Long probesSent;

    /*
     * Number of failed probes.
     */
    private Long probesFailed;

    /**
     * Creates an instance of ConnectivityCheckResponseInner class.
     */
    public ConnectivityCheckResponseInner() {
    }

    /**
     * Get the hops property: List of hops between the source and the destination.
     * 
     * @return the hops value.
     */
    public List<ConnectivityHop> hops() {
        return this.hops;
    }

    /**
     * Get the connectionStatus property: The connection status.
     * 
     * @return the connectionStatus value.
     */
    public ConnectionStatus connectionStatus() {
        return this.connectionStatus;
    }

    /**
     * Get the avgLatencyInMs property: Average latency in milliseconds.
     * 
     * @return the avgLatencyInMs value.
     */
    public Long avgLatencyInMs() {
        return this.avgLatencyInMs;
    }

    /**
     * Get the minLatencyInMs property: Minimum latency in milliseconds.
     * 
     * @return the minLatencyInMs value.
     */
    public Long minLatencyInMs() {
        return this.minLatencyInMs;
    }

    /**
     * Get the maxLatencyInMs property: Maximum latency in milliseconds.
     * 
     * @return the maxLatencyInMs value.
     */
    public Long maxLatencyInMs() {
        return this.maxLatencyInMs;
    }

    /**
     * Get the probesSent property: Total number of probes sent.
     * 
     * @return the probesSent value.
     */
    public Long probesSent() {
        return this.probesSent;
    }

    /**
     * Get the probesFailed property: Number of failed probes.
     * 
     * @return the probesFailed value.
     */
    public Long probesFailed() {
        return this.probesFailed;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (hops() != null) {
            hops().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectivityCheckResponseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectivityCheckResponseInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectivityCheckResponseInner.
     */
    public static ConnectivityCheckResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectivityCheckResponseInner deserializedConnectivityCheckResponseInner
                = new ConnectivityCheckResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("hops".equals(fieldName)) {
                    List<ConnectivityHop> hops = reader.readArray(reader1 -> ConnectivityHop.fromJson(reader1));
                    deserializedConnectivityCheckResponseInner.hops = hops;
                } else if ("connectionStatus".equals(fieldName)) {
                    deserializedConnectivityCheckResponseInner.connectionStatus
                        = ConnectionStatus.fromString(reader.getString());
                } else if ("avgLatencyInMs".equals(fieldName)) {
                    deserializedConnectivityCheckResponseInner.avgLatencyInMs = reader.getNullable(JsonReader::getLong);
                } else if ("minLatencyInMs".equals(fieldName)) {
                    deserializedConnectivityCheckResponseInner.minLatencyInMs = reader.getNullable(JsonReader::getLong);
                } else if ("maxLatencyInMs".equals(fieldName)) {
                    deserializedConnectivityCheckResponseInner.maxLatencyInMs = reader.getNullable(JsonReader::getLong);
                } else if ("probesSent".equals(fieldName)) {
                    deserializedConnectivityCheckResponseInner.probesSent = reader.getNullable(JsonReader::getLong);
                } else if ("probesFailed".equals(fieldName)) {
                    deserializedConnectivityCheckResponseInner.probesFailed = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectivityCheckResponseInner;
        });
    }
}
