// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Content type contract details.
 */
@Fluent
public final class ContentTypeContractInner extends ProxyResource {
    /*
     * Properties of the content type.
     */
    private ContentTypeContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ContentTypeContractInner class.
     */
    public ContentTypeContractInner() {
    }

    /**
     * Get the innerProperties property: Properties of the content type.
     * 
     * @return the innerProperties value.
     */
    private ContentTypeContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the id property: Content type identifier.
     * 
     * @return the id value.
     */
    public String idPropertiesId() {
        return this.innerProperties() == null ? null : this.innerProperties().id();
    }

    /**
     * Set the id property: Content type identifier.
     * 
     * @param id the id value to set.
     * @return the ContentTypeContractInner object itself.
     */
    public ContentTypeContractInner withIdPropertiesId(String id) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContentTypeContractProperties();
        }
        this.innerProperties().withId(id);
        return this;
    }

    /**
     * Get the name property: Content type name. Must be 1 to 250 characters long.
     * 
     * @return the name value.
     */
    public String namePropertiesName() {
        return this.innerProperties() == null ? null : this.innerProperties().name();
    }

    /**
     * Set the name property: Content type name. Must be 1 to 250 characters long.
     * 
     * @param name the name value to set.
     * @return the ContentTypeContractInner object itself.
     */
    public ContentTypeContractInner withNamePropertiesName(String name) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContentTypeContractProperties();
        }
        this.innerProperties().withName(name);
        return this;
    }

    /**
     * Get the description property: Content type description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Content type description.
     * 
     * @param description the description value to set.
     * @return the ContentTypeContractInner object itself.
     */
    public ContentTypeContractInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContentTypeContractProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the schema property: Content type schema.
     * 
     * @return the schema value.
     */
    public Object schema() {
        return this.innerProperties() == null ? null : this.innerProperties().schema();
    }

    /**
     * Set the schema property: Content type schema.
     * 
     * @param schema the schema value to set.
     * @return the ContentTypeContractInner object itself.
     */
    public ContentTypeContractInner withSchema(Object schema) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContentTypeContractProperties();
        }
        this.innerProperties().withSchema(schema);
        return this;
    }

    /**
     * Get the version property: Content type version.
     * 
     * @return the version value.
     */
    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    /**
     * Set the version property: Content type version.
     * 
     * @param version the version value to set.
     * @return the ContentTypeContractInner object itself.
     */
    public ContentTypeContractInner withVersion(String version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContentTypeContractProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContentTypeContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContentTypeContractInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ContentTypeContractInner.
     */
    public static ContentTypeContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContentTypeContractInner deserializedContentTypeContractInner = new ContentTypeContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedContentTypeContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedContentTypeContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedContentTypeContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedContentTypeContractInner.innerProperties
                        = ContentTypeContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContentTypeContractInner;
        });
    }
}
