// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * The DeletedServiceContractProperties model.
 */
@Fluent
public final class DeletedServiceContractProperties implements JsonSerializable<DeletedServiceContractProperties> {
    /*
     * Fully-qualified API Management Service Resource ID
     */
    private String serviceId;

    /*
     * UTC Date and Time when the service will be automatically purged. The date conforms to the following format:
     * yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
     */
    private OffsetDateTime scheduledPurgeDate;

    /*
     * UTC Timestamp when the service was soft-deleted. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ
     * as specified by the ISO 8601 standard.
     */
    private OffsetDateTime deletionDate;

    /**
     * Creates an instance of DeletedServiceContractProperties class.
     */
    public DeletedServiceContractProperties() {
    }

    /**
     * Get the serviceId property: Fully-qualified API Management Service Resource ID.
     * 
     * @return the serviceId value.
     */
    public String serviceId() {
        return this.serviceId;
    }

    /**
     * Set the serviceId property: Fully-qualified API Management Service Resource ID.
     * 
     * @param serviceId the serviceId value to set.
     * @return the DeletedServiceContractProperties object itself.
     */
    public DeletedServiceContractProperties withServiceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    /**
     * Get the scheduledPurgeDate property: UTC Date and Time when the service will be automatically purged. The date
     * conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
     * 
     * @return the scheduledPurgeDate value.
     */
    public OffsetDateTime scheduledPurgeDate() {
        return this.scheduledPurgeDate;
    }

    /**
     * Set the scheduledPurgeDate property: UTC Date and Time when the service will be automatically purged. The date
     * conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
     * 
     * @param scheduledPurgeDate the scheduledPurgeDate value to set.
     * @return the DeletedServiceContractProperties object itself.
     */
    public DeletedServiceContractProperties withScheduledPurgeDate(OffsetDateTime scheduledPurgeDate) {
        this.scheduledPurgeDate = scheduledPurgeDate;
        return this;
    }

    /**
     * Get the deletionDate property: UTC Timestamp when the service was soft-deleted. The date conforms to the
     * following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
     * 
     * @return the deletionDate value.
     */
    public OffsetDateTime deletionDate() {
        return this.deletionDate;
    }

    /**
     * Set the deletionDate property: UTC Timestamp when the service was soft-deleted. The date conforms to the
     * following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
     * 
     * @param deletionDate the deletionDate value to set.
     * @return the DeletedServiceContractProperties object itself.
     */
    public DeletedServiceContractProperties withDeletionDate(OffsetDateTime deletionDate) {
        this.deletionDate = deletionDate;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceId", this.serviceId);
        jsonWriter.writeStringField("scheduledPurgeDate",
            this.scheduledPurgeDate == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.scheduledPurgeDate));
        jsonWriter.writeStringField("deletionDate",
            this.deletionDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deletionDate));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeletedServiceContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeletedServiceContractProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeletedServiceContractProperties.
     */
    public static DeletedServiceContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeletedServiceContractProperties deserializedDeletedServiceContractProperties
                = new DeletedServiceContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("serviceId".equals(fieldName)) {
                    deserializedDeletedServiceContractProperties.serviceId = reader.getString();
                } else if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedDeletedServiceContractProperties.scheduledPurgeDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("deletionDate".equals(fieldName)) {
                    deserializedDeletedServiceContractProperties.deletionDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeletedServiceContractProperties;
        });
    }
}
