// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Markdown documentation details.
 */
@Fluent
public final class DocumentationContractInner extends ProxyResource {
    /*
     * Markdown Documentation details.
     */
    private DocumentationContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of DocumentationContractInner class.
     */
    public DocumentationContractInner() {
    }

    /**
     * Get the innerProperties property: Markdown Documentation details.
     * 
     * @return the innerProperties value.
     */
    private DocumentationContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the title property: documentation title.
     * 
     * @return the title value.
     */
    public String title() {
        return this.innerProperties() == null ? null : this.innerProperties().title();
    }

    /**
     * Set the title property: documentation title.
     * 
     * @param title the title value to set.
     * @return the DocumentationContractInner object itself.
     */
    public DocumentationContractInner withTitle(String title) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DocumentationContractProperties();
        }
        this.innerProperties().withTitle(title);
        return this;
    }

    /**
     * Get the content property: Markdown documentation content.
     * 
     * @return the content value.
     */
    public String content() {
        return this.innerProperties() == null ? null : this.innerProperties().content();
    }

    /**
     * Set the content property: Markdown documentation content.
     * 
     * @param content the content value to set.
     * @return the DocumentationContractInner object itself.
     */
    public DocumentationContractInner withContent(String content) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DocumentationContractProperties();
        }
        this.innerProperties().withContent(content);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentationContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentationContractInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DocumentationContractInner.
     */
    public static DocumentationContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DocumentationContractInner deserializedDocumentationContractInner = new DocumentationContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDocumentationContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDocumentationContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDocumentationContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedDocumentationContractInner.innerProperties
                        = DocumentationContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDocumentationContractInner;
        });
    }
}
