// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Markdown documentation details.
 */
@Fluent
public final class DocumentationContractProperties implements JsonSerializable<DocumentationContractProperties> {
    /*
     * documentation title.
     */
    private String title;

    /*
     * Markdown documentation content.
     */
    private String content;

    /**
     * Creates an instance of DocumentationContractProperties class.
     */
    public DocumentationContractProperties() {
    }

    /**
     * Get the title property: documentation title.
     * 
     * @return the title value.
     */
    public String title() {
        return this.title;
    }

    /**
     * Set the title property: documentation title.
     * 
     * @param title the title value to set.
     * @return the DocumentationContractProperties object itself.
     */
    public DocumentationContractProperties withTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * Get the content property: Markdown documentation content.
     * 
     * @return the content value.
     */
    public String content() {
        return this.content;
    }

    /**
     * Set the content property: Markdown documentation content.
     * 
     * @param content the content value to set.
     * @return the DocumentationContractProperties object itself.
     */
    public DocumentationContractProperties withContent(String content) {
        this.content = content;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("content", this.content);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentationContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentationContractProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DocumentationContractProperties.
     */
    public static DocumentationContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DocumentationContractProperties deserializedDocumentationContractProperties
                = new DocumentationContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("title".equals(fieldName)) {
                    deserializedDocumentationContractProperties.title = reader.getString();
                } else if ("content".equals(fieldName)) {
                    deserializedDocumentationContractProperties.content = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDocumentationContractProperties;
        });
    }
}
