// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.EmailTemplateParametersContractProperties;
import java.io.IOException;
import java.util.List;

/**
 * Email Template details.
 */
@Fluent
public final class EmailTemplateContractInner extends ProxyResource {
    /*
     * Email Template entity contract properties.
     */
    private EmailTemplateContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of EmailTemplateContractInner class.
     */
    public EmailTemplateContractInner() {
    }

    /**
     * Get the innerProperties property: Email Template entity contract properties.
     * 
     * @return the innerProperties value.
     */
    private EmailTemplateContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the subject property: Subject of the Template.
     * 
     * @return the subject value.
     */
    public String subject() {
        return this.innerProperties() == null ? null : this.innerProperties().subject();
    }

    /**
     * Set the subject property: Subject of the Template.
     * 
     * @param subject the subject value to set.
     * @return the EmailTemplateContractInner object itself.
     */
    public EmailTemplateContractInner withSubject(String subject) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EmailTemplateContractProperties();
        }
        this.innerProperties().withSubject(subject);
        return this;
    }

    /**
     * Get the body property: Email Template Body. This should be a valid XDocument.
     * 
     * @return the body value.
     */
    public String body() {
        return this.innerProperties() == null ? null : this.innerProperties().body();
    }

    /**
     * Set the body property: Email Template Body. This should be a valid XDocument.
     * 
     * @param body the body value to set.
     * @return the EmailTemplateContractInner object itself.
     */
    public EmailTemplateContractInner withBody(String body) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EmailTemplateContractProperties();
        }
        this.innerProperties().withBody(body);
        return this;
    }

    /**
     * Get the title property: Title of the Template.
     * 
     * @return the title value.
     */
    public String title() {
        return this.innerProperties() == null ? null : this.innerProperties().title();
    }

    /**
     * Set the title property: Title of the Template.
     * 
     * @param title the title value to set.
     * @return the EmailTemplateContractInner object itself.
     */
    public EmailTemplateContractInner withTitle(String title) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EmailTemplateContractProperties();
        }
        this.innerProperties().withTitle(title);
        return this;
    }

    /**
     * Get the description property: Description of the Email Template.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Description of the Email Template.
     * 
     * @param description the description value to set.
     * @return the EmailTemplateContractInner object itself.
     */
    public EmailTemplateContractInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EmailTemplateContractProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the isDefault property: Whether the template is the default template provided by API Management or has been
     * edited.
     * 
     * @return the isDefault value.
     */
    public Boolean isDefault() {
        return this.innerProperties() == null ? null : this.innerProperties().isDefault();
    }

    /**
     * Get the parameters property: Email Template Parameter values.
     * 
     * @return the parameters value.
     */
    public List<EmailTemplateParametersContractProperties> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    /**
     * Set the parameters property: Email Template Parameter values.
     * 
     * @param parameters the parameters value to set.
     * @return the EmailTemplateContractInner object itself.
     */
    public EmailTemplateContractInner withParameters(List<EmailTemplateParametersContractProperties> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EmailTemplateContractProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EmailTemplateContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EmailTemplateContractInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the EmailTemplateContractInner.
     */
    public static EmailTemplateContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EmailTemplateContractInner deserializedEmailTemplateContractInner = new EmailTemplateContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedEmailTemplateContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedEmailTemplateContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedEmailTemplateContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedEmailTemplateContractInner.innerProperties
                        = EmailTemplateContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEmailTemplateContractInner;
        });
    }
}
