// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Gateway certificate authority details.
 */
@Fluent
public final class GatewayCertificateAuthorityContractProperties
    implements JsonSerializable<GatewayCertificateAuthorityContractProperties> {
    /*
     * Determines whether certificate authority is trusted.
     */
    private Boolean isTrusted;

    /**
     * Creates an instance of GatewayCertificateAuthorityContractProperties class.
     */
    public GatewayCertificateAuthorityContractProperties() {
    }

    /**
     * Get the isTrusted property: Determines whether certificate authority is trusted.
     * 
     * @return the isTrusted value.
     */
    public Boolean isTrusted() {
        return this.isTrusted;
    }

    /**
     * Set the isTrusted property: Determines whether certificate authority is trusted.
     * 
     * @param isTrusted the isTrusted value to set.
     * @return the GatewayCertificateAuthorityContractProperties object itself.
     */
    public GatewayCertificateAuthorityContractProperties withIsTrusted(Boolean isTrusted) {
        this.isTrusted = isTrusted;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isTrusted", this.isTrusted);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayCertificateAuthorityContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayCertificateAuthorityContractProperties if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GatewayCertificateAuthorityContractProperties.
     */
    public static GatewayCertificateAuthorityContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayCertificateAuthorityContractProperties deserializedGatewayCertificateAuthorityContractProperties
                = new GatewayCertificateAuthorityContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("isTrusted".equals(fieldName)) {
                    deserializedGatewayCertificateAuthorityContractProperties.isTrusted
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayCertificateAuthorityContractProperties;
        });
    }
}
