// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The GatewayConfigConnectionBaseProperties model.
 */
@Fluent
public final class GatewayConfigConnectionBaseProperties
    implements JsonSerializable<GatewayConfigConnectionBaseProperties> {
    /*
     * The current provisioning state of the API Management gateway config connection
     */
    private String provisioningState;

    /*
     * The link to the API Management service workspace.
     */
    private String sourceId;

    /*
     * The default hostname of the data-plane gateway.
     */
    private String defaultHostname;

    /*
     * The hostnames of the data-plane gateway to which requests can be sent.
     */
    private List<String> hostnames;

    /**
     * Creates an instance of GatewayConfigConnectionBaseProperties class.
     */
    public GatewayConfigConnectionBaseProperties() {
    }

    /**
     * Get the provisioningState property: The current provisioning state of the API Management gateway config
     * connection.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the sourceId property: The link to the API Management service workspace.
     * 
     * @return the sourceId value.
     */
    public String sourceId() {
        return this.sourceId;
    }

    /**
     * Set the sourceId property: The link to the API Management service workspace.
     * 
     * @param sourceId the sourceId value to set.
     * @return the GatewayConfigConnectionBaseProperties object itself.
     */
    public GatewayConfigConnectionBaseProperties withSourceId(String sourceId) {
        this.sourceId = sourceId;
        return this;
    }

    /**
     * Get the defaultHostname property: The default hostname of the data-plane gateway.
     * 
     * @return the defaultHostname value.
     */
    public String defaultHostname() {
        return this.defaultHostname;
    }

    /**
     * Get the hostnames property: The hostnames of the data-plane gateway to which requests can be sent.
     * 
     * @return the hostnames value.
     */
    public List<String> hostnames() {
        return this.hostnames;
    }

    /**
     * Set the hostnames property: The hostnames of the data-plane gateway to which requests can be sent.
     * 
     * @param hostnames the hostnames value to set.
     * @return the GatewayConfigConnectionBaseProperties object itself.
     */
    public GatewayConfigConnectionBaseProperties withHostnames(List<String> hostnames) {
        this.hostnames = hostnames;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceId", this.sourceId);
        jsonWriter.writeArrayField("hostnames", this.hostnames, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayConfigConnectionBaseProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayConfigConnectionBaseProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GatewayConfigConnectionBaseProperties.
     */
    public static GatewayConfigConnectionBaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayConfigConnectionBaseProperties deserializedGatewayConfigConnectionBaseProperties
                = new GatewayConfigConnectionBaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedGatewayConfigConnectionBaseProperties.provisioningState = reader.getString();
                } else if ("sourceId".equals(fieldName)) {
                    deserializedGatewayConfigConnectionBaseProperties.sourceId = reader.getString();
                } else if ("defaultHostname".equals(fieldName)) {
                    deserializedGatewayConfigConnectionBaseProperties.defaultHostname = reader.getString();
                } else if ("hostnames".equals(fieldName)) {
                    List<String> hostnames = reader.readArray(reader1 -> reader1.getString());
                    deserializedGatewayConfigConnectionBaseProperties.hostnames = hostnames;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayConfigConnectionBaseProperties;
        });
    }
}
