// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ResourceLocationDataContract;
import java.io.IOException;

/**
 * Gateway details.
 */
@Fluent
public final class GatewayContractInner extends ProxyResource {
    /*
     * Gateway details.
     */
    private GatewayContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of GatewayContractInner class.
     */
    public GatewayContractInner() {
    }

    /**
     * Get the innerProperties property: Gateway details.
     * 
     * @return the innerProperties value.
     */
    private GatewayContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the locationData property: Gateway location.
     * 
     * @return the locationData value.
     */
    public ResourceLocationDataContract locationData() {
        return this.innerProperties() == null ? null : this.innerProperties().locationData();
    }

    /**
     * Set the locationData property: Gateway location.
     * 
     * @param locationData the locationData value to set.
     * @return the GatewayContractInner object itself.
     */
    public GatewayContractInner withLocationData(ResourceLocationDataContract locationData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GatewayContractProperties();
        }
        this.innerProperties().withLocationData(locationData);
        return this;
    }

    /**
     * Get the description property: Gateway description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Gateway description.
     * 
     * @param description the description value to set.
     * @return the GatewayContractInner object itself.
     */
    public GatewayContractInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GatewayContractProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayContractInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GatewayContractInner.
     */
    public static GatewayContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayContractInner deserializedGatewayContractInner = new GatewayContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedGatewayContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedGatewayContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedGatewayContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedGatewayContractInner.innerProperties = GatewayContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayContractInner;
        });
    }
}
