// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ResourceLocationDataContract;
import java.io.IOException;

/**
 * Properties of the Gateway contract.
 */
@Fluent
public final class GatewayContractProperties implements JsonSerializable<GatewayContractProperties> {
    /*
     * Gateway location.
     */
    private ResourceLocationDataContract locationData;

    /*
     * Gateway description
     */
    private String description;

    /**
     * Creates an instance of GatewayContractProperties class.
     */
    public GatewayContractProperties() {
    }

    /**
     * Get the locationData property: Gateway location.
     * 
     * @return the locationData value.
     */
    public ResourceLocationDataContract locationData() {
        return this.locationData;
    }

    /**
     * Set the locationData property: Gateway location.
     * 
     * @param locationData the locationData value to set.
     * @return the GatewayContractProperties object itself.
     */
    public GatewayContractProperties withLocationData(ResourceLocationDataContract locationData) {
        this.locationData = locationData;
        return this;
    }

    /**
     * Get the description property: Gateway description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Gateway description.
     * 
     * @param description the description value to set.
     * @return the GatewayContractProperties object itself.
     */
    public GatewayContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (locationData() != null) {
            locationData().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("locationData", this.locationData);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayContractProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GatewayContractProperties.
     */
    public static GatewayContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayContractProperties deserializedGatewayContractProperties = new GatewayContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("locationData".equals(fieldName)) {
                    deserializedGatewayContractProperties.locationData = ResourceLocationDataContract.fromJson(reader);
                } else if ("description".equals(fieldName)) {
                    deserializedGatewayContractProperties.description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayContractProperties;
        });
    }
}
