// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Gateway hostname configuration details.
 */
@Fluent
public final class GatewayHostnameConfigurationContractInner extends ProxyResource {
    /*
     * Gateway hostname configuration details.
     */
    private GatewayHostnameConfigurationContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of GatewayHostnameConfigurationContractInner class.
     */
    public GatewayHostnameConfigurationContractInner() {
    }

    /**
     * Get the innerProperties property: Gateway hostname configuration details.
     * 
     * @return the innerProperties value.
     */
    private GatewayHostnameConfigurationContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the hostname property: Hostname value. Supports valid domain name, partial or full wildcard.
     * 
     * @return the hostname value.
     */
    public String hostname() {
        return this.innerProperties() == null ? null : this.innerProperties().hostname();
    }

    /**
     * Set the hostname property: Hostname value. Supports valid domain name, partial or full wildcard.
     * 
     * @param hostname the hostname value to set.
     * @return the GatewayHostnameConfigurationContractInner object itself.
     */
    public GatewayHostnameConfigurationContractInner withHostname(String hostname) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GatewayHostnameConfigurationContractProperties();
        }
        this.innerProperties().withHostname(hostname);
        return this;
    }

    /**
     * Get the certificateId property: Identifier of Certificate entity that will be used for TLS connection
     * establishment.
     * 
     * @return the certificateId value.
     */
    public String certificateId() {
        return this.innerProperties() == null ? null : this.innerProperties().certificateId();
    }

    /**
     * Set the certificateId property: Identifier of Certificate entity that will be used for TLS connection
     * establishment.
     * 
     * @param certificateId the certificateId value to set.
     * @return the GatewayHostnameConfigurationContractInner object itself.
     */
    public GatewayHostnameConfigurationContractInner withCertificateId(String certificateId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GatewayHostnameConfigurationContractProperties();
        }
        this.innerProperties().withCertificateId(certificateId);
        return this;
    }

    /**
     * Get the negotiateClientCertificate property: Determines whether gateway requests client certificate.
     * 
     * @return the negotiateClientCertificate value.
     */
    public Boolean negotiateClientCertificate() {
        return this.innerProperties() == null ? null : this.innerProperties().negotiateClientCertificate();
    }

    /**
     * Set the negotiateClientCertificate property: Determines whether gateway requests client certificate.
     * 
     * @param negotiateClientCertificate the negotiateClientCertificate value to set.
     * @return the GatewayHostnameConfigurationContractInner object itself.
     */
    public GatewayHostnameConfigurationContractInner
        withNegotiateClientCertificate(Boolean negotiateClientCertificate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GatewayHostnameConfigurationContractProperties();
        }
        this.innerProperties().withNegotiateClientCertificate(negotiateClientCertificate);
        return this;
    }

    /**
     * Get the tls10Enabled property: Specifies if TLS 1.0 is supported.
     * 
     * @return the tls10Enabled value.
     */
    public Boolean tls10Enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().tls10Enabled();
    }

    /**
     * Set the tls10Enabled property: Specifies if TLS 1.0 is supported.
     * 
     * @param tls10Enabled the tls10Enabled value to set.
     * @return the GatewayHostnameConfigurationContractInner object itself.
     */
    public GatewayHostnameConfigurationContractInner withTls10Enabled(Boolean tls10Enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GatewayHostnameConfigurationContractProperties();
        }
        this.innerProperties().withTls10Enabled(tls10Enabled);
        return this;
    }

    /**
     * Get the tls11Enabled property: Specifies if TLS 1.1 is supported.
     * 
     * @return the tls11Enabled value.
     */
    public Boolean tls11Enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().tls11Enabled();
    }

    /**
     * Set the tls11Enabled property: Specifies if TLS 1.1 is supported.
     * 
     * @param tls11Enabled the tls11Enabled value to set.
     * @return the GatewayHostnameConfigurationContractInner object itself.
     */
    public GatewayHostnameConfigurationContractInner withTls11Enabled(Boolean tls11Enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GatewayHostnameConfigurationContractProperties();
        }
        this.innerProperties().withTls11Enabled(tls11Enabled);
        return this;
    }

    /**
     * Get the http2Enabled property: Specifies if HTTP/2.0 is supported.
     * 
     * @return the http2Enabled value.
     */
    public Boolean http2Enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().http2Enabled();
    }

    /**
     * Set the http2Enabled property: Specifies if HTTP/2.0 is supported.
     * 
     * @param http2Enabled the http2Enabled value to set.
     * @return the GatewayHostnameConfigurationContractInner object itself.
     */
    public GatewayHostnameConfigurationContractInner withHttp2Enabled(Boolean http2Enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GatewayHostnameConfigurationContractProperties();
        }
        this.innerProperties().withHttp2Enabled(http2Enabled);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayHostnameConfigurationContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayHostnameConfigurationContractInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GatewayHostnameConfigurationContractInner.
     */
    public static GatewayHostnameConfigurationContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayHostnameConfigurationContractInner deserializedGatewayHostnameConfigurationContractInner
                = new GatewayHostnameConfigurationContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedGatewayHostnameConfigurationContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedGatewayHostnameConfigurationContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedGatewayHostnameConfigurationContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedGatewayHostnameConfigurationContractInner.innerProperties
                        = GatewayHostnameConfigurationContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayHostnameConfigurationContractInner;
        });
    }
}
