// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Gateway access token.
 */
@Fluent
public final class GatewayTokenContractInner implements JsonSerializable<GatewayTokenContractInner> {
    /*
     * Shared Access Authentication token value for the Gateway.
     */
    private String value;

    /**
     * Creates an instance of GatewayTokenContractInner class.
     */
    public GatewayTokenContractInner() {
    }

    /**
     * Get the value property: Shared Access Authentication token value for the Gateway.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Shared Access Authentication token value for the Gateway.
     * 
     * @param value the value value to set.
     * @return the GatewayTokenContractInner object itself.
     */
    public GatewayTokenContractInner withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayTokenContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayTokenContractInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GatewayTokenContractInner.
     */
    public static GatewayTokenContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayTokenContractInner deserializedGatewayTokenContractInner = new GatewayTokenContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedGatewayTokenContractInner.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayTokenContractInner;
        });
    }
}
