// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.SchemaType;
import java.io.IOException;

/**
 * Schema create or update contract Properties.
 */
@Fluent
public final class GlobalSchemaContractProperties implements JsonSerializable<GlobalSchemaContractProperties> {
    /*
     * Schema Type. Immutable.
     */
    private SchemaType schemaType;

    /*
     * Free-form schema entity description.
     */
    private String description;

    /*
     * Json-encoded string for non json-based schema.
     */
    private Object value;

    /*
     * Global Schema document object for json-based schema formats(e.g. json schema).
     */
    private Object document;

    /*
     * The provisioning state
     */
    private String provisioningState;

    /**
     * Creates an instance of GlobalSchemaContractProperties class.
     */
    public GlobalSchemaContractProperties() {
    }

    /**
     * Get the schemaType property: Schema Type. Immutable.
     * 
     * @return the schemaType value.
     */
    public SchemaType schemaType() {
        return this.schemaType;
    }

    /**
     * Set the schemaType property: Schema Type. Immutable.
     * 
     * @param schemaType the schemaType value to set.
     * @return the GlobalSchemaContractProperties object itself.
     */
    public GlobalSchemaContractProperties withSchemaType(SchemaType schemaType) {
        this.schemaType = schemaType;
        return this;
    }

    /**
     * Get the description property: Free-form schema entity description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Free-form schema entity description.
     * 
     * @param description the description value to set.
     * @return the GlobalSchemaContractProperties object itself.
     */
    public GlobalSchemaContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the value property: Json-encoded string for non json-based schema.
     * 
     * @return the value value.
     */
    public Object value() {
        return this.value;
    }

    /**
     * Set the value property: Json-encoded string for non json-based schema.
     * 
     * @param value the value value to set.
     * @return the GlobalSchemaContractProperties object itself.
     */
    public GlobalSchemaContractProperties withValue(Object value) {
        this.value = value;
        return this;
    }

    /**
     * Get the document property: Global Schema document object for json-based schema formats(e.g. json schema).
     * 
     * @return the document value.
     */
    public Object document() {
        return this.document;
    }

    /**
     * Set the document property: Global Schema document object for json-based schema formats(e.g. json schema).
     * 
     * @param document the document value to set.
     * @return the GlobalSchemaContractProperties object itself.
     */
    public GlobalSchemaContractProperties withDocument(Object document) {
        this.document = document;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (schemaType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property schemaType in model GlobalSchemaContractProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GlobalSchemaContractProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("schemaType", this.schemaType == null ? null : this.schemaType.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeUntypedField("value", this.value);
        jsonWriter.writeUntypedField("document", this.document);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GlobalSchemaContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GlobalSchemaContractProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GlobalSchemaContractProperties.
     */
    public static GlobalSchemaContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GlobalSchemaContractProperties deserializedGlobalSchemaContractProperties
                = new GlobalSchemaContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("schemaType".equals(fieldName)) {
                    deserializedGlobalSchemaContractProperties.schemaType = SchemaType.fromString(reader.getString());
                } else if ("description".equals(fieldName)) {
                    deserializedGlobalSchemaContractProperties.description = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedGlobalSchemaContractProperties.value = reader.readUntyped();
                } else if ("document".equals(fieldName)) {
                    deserializedGlobalSchemaContractProperties.document = reader.readUntyped();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedGlobalSchemaContractProperties.provisioningState = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGlobalSchemaContractProperties;
        });
    }
}
