// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.GroupType;
import java.io.IOException;

/**
 * Contract details.
 */
@Fluent
public final class GroupContractInner extends ProxyResource {
    /*
     * Group entity contract properties.
     */
    private GroupContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of GroupContractInner class.
     */
    public GroupContractInner() {
    }

    /**
     * Get the innerProperties property: Group entity contract properties.
     * 
     * @return the innerProperties value.
     */
    private GroupContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the displayName property: Group name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: Group name.
     * 
     * @param displayName the displayName value to set.
     * @return the GroupContractInner object itself.
     */
    public GroupContractInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GroupContractProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the description property: Group description. Can contain HTML formatting tags.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Group description. Can contain HTML formatting tags.
     * 
     * @param description the description value to set.
     * @return the GroupContractInner object itself.
     */
    public GroupContractInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GroupContractProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the builtIn property: true if the group is one of the three system groups (Administrators, Developers, or
     * Guests); otherwise false.
     * 
     * @return the builtIn value.
     */
    public Boolean builtIn() {
        return this.innerProperties() == null ? null : this.innerProperties().builtIn();
    }

    /**
     * Get the type property: Group type.
     * 
     * @return the type value.
     */
    public GroupType typePropertiesType() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    /**
     * Set the type property: Group type.
     * 
     * @param type the type value to set.
     * @return the GroupContractInner object itself.
     */
    public GroupContractInner withTypePropertiesType(GroupType type) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GroupContractProperties();
        }
        this.innerProperties().withType(type);
        return this;
    }

    /**
     * Get the externalId property: For external groups, this property contains the id of the group from the external
     * identity provider, e.g. for Azure Active Directory `aad://&lt;tenant&gt;.onmicrosoft.com/groups/&lt;group object
     * id&gt;`; otherwise the value is null.
     * 
     * @return the externalId value.
     */
    public String externalId() {
        return this.innerProperties() == null ? null : this.innerProperties().externalId();
    }

    /**
     * Set the externalId property: For external groups, this property contains the id of the group from the external
     * identity provider, e.g. for Azure Active Directory `aad://&lt;tenant&gt;.onmicrosoft.com/groups/&lt;group object
     * id&gt;`; otherwise the value is null.
     * 
     * @param externalId the externalId value to set.
     * @return the GroupContractInner object itself.
     */
    public GroupContractInner withExternalId(String externalId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GroupContractProperties();
        }
        this.innerProperties().withExternalId(externalId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GroupContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GroupContractInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GroupContractInner.
     */
    public static GroupContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GroupContractInner deserializedGroupContractInner = new GroupContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedGroupContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedGroupContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedGroupContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedGroupContractInner.innerProperties = GroupContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGroupContractInner;
        });
    }
}
