// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.GroupType;
import java.io.IOException;

/**
 * Group contract Properties.
 */
@Fluent
public final class GroupContractProperties implements JsonSerializable<GroupContractProperties> {
    /*
     * Group name.
     */
    private String displayName;

    /*
     * Group description. Can contain HTML formatting tags.
     */
    private String description;

    /*
     * true if the group is one of the three system groups (Administrators, Developers, or Guests); otherwise false.
     */
    private Boolean builtIn;

    /*
     * Group type.
     */
    private GroupType type;

    /*
     * For external groups, this property contains the id of the group from the external identity provider, e.g. for
     * Azure Active Directory `aad://<tenant>.onmicrosoft.com/groups/<group object id>`; otherwise the value is null.
     */
    private String externalId;

    /**
     * Creates an instance of GroupContractProperties class.
     */
    public GroupContractProperties() {
    }

    /**
     * Get the displayName property: Group name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Group name.
     * 
     * @param displayName the displayName value to set.
     * @return the GroupContractProperties object itself.
     */
    public GroupContractProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the description property: Group description. Can contain HTML formatting tags.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Group description. Can contain HTML formatting tags.
     * 
     * @param description the description value to set.
     * @return the GroupContractProperties object itself.
     */
    public GroupContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the builtIn property: true if the group is one of the three system groups (Administrators, Developers, or
     * Guests); otherwise false.
     * 
     * @return the builtIn value.
     */
    public Boolean builtIn() {
        return this.builtIn;
    }

    /**
     * Get the type property: Group type.
     * 
     * @return the type value.
     */
    public GroupType type() {
        return this.type;
    }

    /**
     * Set the type property: Group type.
     * 
     * @param type the type value to set.
     * @return the GroupContractProperties object itself.
     */
    public GroupContractProperties withType(GroupType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the externalId property: For external groups, this property contains the id of the group from the external
     * identity provider, e.g. for Azure Active Directory `aad://&lt;tenant&gt;.onmicrosoft.com/groups/&lt;group object
     * id&gt;`; otherwise the value is null.
     * 
     * @return the externalId value.
     */
    public String externalId() {
        return this.externalId;
    }

    /**
     * Set the externalId property: For external groups, this property contains the id of the group from the external
     * identity provider, e.g. for Azure Active Directory `aad://&lt;tenant&gt;.onmicrosoft.com/groups/&lt;group object
     * id&gt;`; otherwise the value is null.
     * 
     * @param externalId the externalId value to set.
     * @return the GroupContractProperties object itself.
     */
    public GroupContractProperties withExternalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (displayName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property displayName in model GroupContractProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GroupContractProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("externalId", this.externalId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GroupContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GroupContractProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GroupContractProperties.
     */
    public static GroupContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GroupContractProperties deserializedGroupContractProperties = new GroupContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("displayName".equals(fieldName)) {
                    deserializedGroupContractProperties.displayName = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedGroupContractProperties.description = reader.getString();
                } else if ("builtIn".equals(fieldName)) {
                    deserializedGroupContractProperties.builtIn = reader.getNullable(JsonReader::getBoolean);
                } else if ("type".equals(fieldName)) {
                    deserializedGroupContractProperties.type = GroupType.fromString(reader.getString());
                } else if ("externalId".equals(fieldName)) {
                    deserializedGroupContractProperties.externalId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGroupContractProperties;
        });
    }
}
