// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.GroupType;
import java.io.IOException;

/**
 * Parameters supplied to the Update Group operation.
 */
@Fluent
public final class GroupUpdateParametersProperties implements JsonSerializable<GroupUpdateParametersProperties> {
    /*
     * Group name.
     */
    private String displayName;

    /*
     * Group description.
     */
    private String description;

    /*
     * Group type.
     */
    private GroupType type;

    /*
     * Identifier of the external groups, this property contains the id of the group from the external identity
     * provider, e.g. for Azure Active Directory `aad://<tenant>.onmicrosoft.com/groups/<group object id>`; otherwise
     * the value is null.
     */
    private String externalId;

    /**
     * Creates an instance of GroupUpdateParametersProperties class.
     */
    public GroupUpdateParametersProperties() {
    }

    /**
     * Get the displayName property: Group name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Group name.
     * 
     * @param displayName the displayName value to set.
     * @return the GroupUpdateParametersProperties object itself.
     */
    public GroupUpdateParametersProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the description property: Group description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Group description.
     * 
     * @param description the description value to set.
     * @return the GroupUpdateParametersProperties object itself.
     */
    public GroupUpdateParametersProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the type property: Group type.
     * 
     * @return the type value.
     */
    public GroupType type() {
        return this.type;
    }

    /**
     * Set the type property: Group type.
     * 
     * @param type the type value to set.
     * @return the GroupUpdateParametersProperties object itself.
     */
    public GroupUpdateParametersProperties withType(GroupType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the externalId property: Identifier of the external groups, this property contains the id of the group from
     * the external identity provider, e.g. for Azure Active Directory
     * `aad://&lt;tenant&gt;.onmicrosoft.com/groups/&lt;group object id&gt;`; otherwise the value is null.
     * 
     * @return the externalId value.
     */
    public String externalId() {
        return this.externalId;
    }

    /**
     * Set the externalId property: Identifier of the external groups, this property contains the id of the group from
     * the external identity provider, e.g. for Azure Active Directory
     * `aad://&lt;tenant&gt;.onmicrosoft.com/groups/&lt;group object id&gt;`; otherwise the value is null.
     * 
     * @param externalId the externalId value to set.
     * @return the GroupUpdateParametersProperties object itself.
     */
    public GroupUpdateParametersProperties withExternalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("externalId", this.externalId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GroupUpdateParametersProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GroupUpdateParametersProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GroupUpdateParametersProperties.
     */
    public static GroupUpdateParametersProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GroupUpdateParametersProperties deserializedGroupUpdateParametersProperties
                = new GroupUpdateParametersProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("displayName".equals(fieldName)) {
                    deserializedGroupUpdateParametersProperties.displayName = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedGroupUpdateParametersProperties.description = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedGroupUpdateParametersProperties.type = GroupType.fromString(reader.getString());
                } else if ("externalId".equals(fieldName)) {
                    deserializedGroupUpdateParametersProperties.externalId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGroupUpdateParametersProperties;
        });
    }
}
