// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Issue Attachment contract Properties.
 */
@Fluent
public final class IssueAttachmentContractProperties implements JsonSerializable<IssueAttachmentContractProperties> {
    /*
     * Filename by which the binary data will be saved.
     */
    private String title;

    /*
     * Either 'link' if content is provided via an HTTP link or the MIME type of the Base64-encoded binary data provided
     * in the 'content' property.
     */
    private String contentFormat;

    /*
     * An HTTP link or Base64-encoded binary data.
     */
    private String content;

    /**
     * Creates an instance of IssueAttachmentContractProperties class.
     */
    public IssueAttachmentContractProperties() {
    }

    /**
     * Get the title property: Filename by which the binary data will be saved.
     * 
     * @return the title value.
     */
    public String title() {
        return this.title;
    }

    /**
     * Set the title property: Filename by which the binary data will be saved.
     * 
     * @param title the title value to set.
     * @return the IssueAttachmentContractProperties object itself.
     */
    public IssueAttachmentContractProperties withTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * Get the contentFormat property: Either 'link' if content is provided via an HTTP link or the MIME type of the
     * Base64-encoded binary data provided in the 'content' property.
     * 
     * @return the contentFormat value.
     */
    public String contentFormat() {
        return this.contentFormat;
    }

    /**
     * Set the contentFormat property: Either 'link' if content is provided via an HTTP link or the MIME type of the
     * Base64-encoded binary data provided in the 'content' property.
     * 
     * @param contentFormat the contentFormat value to set.
     * @return the IssueAttachmentContractProperties object itself.
     */
    public IssueAttachmentContractProperties withContentFormat(String contentFormat) {
        this.contentFormat = contentFormat;
        return this;
    }

    /**
     * Get the content property: An HTTP link or Base64-encoded binary data.
     * 
     * @return the content value.
     */
    public String content() {
        return this.content;
    }

    /**
     * Set the content property: An HTTP link or Base64-encoded binary data.
     * 
     * @param content the content value to set.
     * @return the IssueAttachmentContractProperties object itself.
     */
    public IssueAttachmentContractProperties withContent(String content) {
        this.content = content;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (title() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property title in model IssueAttachmentContractProperties"));
        }
        if (contentFormat() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property contentFormat in model IssueAttachmentContractProperties"));
        }
        if (content() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property content in model IssueAttachmentContractProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(IssueAttachmentContractProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("contentFormat", this.contentFormat);
        jsonWriter.writeStringField("content", this.content);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IssueAttachmentContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IssueAttachmentContractProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the IssueAttachmentContractProperties.
     */
    public static IssueAttachmentContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IssueAttachmentContractProperties deserializedIssueAttachmentContractProperties
                = new IssueAttachmentContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("title".equals(fieldName)) {
                    deserializedIssueAttachmentContractProperties.title = reader.getString();
                } else if ("contentFormat".equals(fieldName)) {
                    deserializedIssueAttachmentContractProperties.contentFormat = reader.getString();
                } else if ("content".equals(fieldName)) {
                    deserializedIssueAttachmentContractProperties.content = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIssueAttachmentContractProperties;
        });
    }
}
