// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Issue Comment Contract details.
 */
@Fluent
public final class IssueCommentContractInner extends ProxyResource {
    /*
     * Properties of the Issue Comment.
     */
    private IssueCommentContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of IssueCommentContractInner class.
     */
    public IssueCommentContractInner() {
    }

    /**
     * Get the innerProperties property: Properties of the Issue Comment.
     * 
     * @return the innerProperties value.
     */
    private IssueCommentContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the text property: Comment text.
     * 
     * @return the text value.
     */
    public String text() {
        return this.innerProperties() == null ? null : this.innerProperties().text();
    }

    /**
     * Set the text property: Comment text.
     * 
     * @param text the text value to set.
     * @return the IssueCommentContractInner object itself.
     */
    public IssueCommentContractInner withText(String text) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IssueCommentContractProperties();
        }
        this.innerProperties().withText(text);
        return this;
    }

    /**
     * Get the createdDate property: Date and time when the comment was created.
     * 
     * @return the createdDate value.
     */
    public OffsetDateTime createdDate() {
        return this.innerProperties() == null ? null : this.innerProperties().createdDate();
    }

    /**
     * Set the createdDate property: Date and time when the comment was created.
     * 
     * @param createdDate the createdDate value to set.
     * @return the IssueCommentContractInner object itself.
     */
    public IssueCommentContractInner withCreatedDate(OffsetDateTime createdDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IssueCommentContractProperties();
        }
        this.innerProperties().withCreatedDate(createdDate);
        return this;
    }

    /**
     * Get the userId property: A resource identifier for the user who left the comment.
     * 
     * @return the userId value.
     */
    public String userId() {
        return this.innerProperties() == null ? null : this.innerProperties().userId();
    }

    /**
     * Set the userId property: A resource identifier for the user who left the comment.
     * 
     * @param userId the userId value to set.
     * @return the IssueCommentContractInner object itself.
     */
    public IssueCommentContractInner withUserId(String userId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IssueCommentContractProperties();
        }
        this.innerProperties().withUserId(userId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IssueCommentContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IssueCommentContractInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the IssueCommentContractInner.
     */
    public static IssueCommentContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IssueCommentContractInner deserializedIssueCommentContractInner = new IssueCommentContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedIssueCommentContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedIssueCommentContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedIssueCommentContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedIssueCommentContractInner.innerProperties
                        = IssueCommentContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIssueCommentContractInner;
        });
    }
}
