// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Issue Comment contract Properties.
 */
@Fluent
public final class IssueCommentContractProperties implements JsonSerializable<IssueCommentContractProperties> {
    /*
     * Comment text.
     */
    private String text;

    /*
     * Date and time when the comment was created.
     */
    private OffsetDateTime createdDate;

    /*
     * A resource identifier for the user who left the comment.
     */
    private String userId;

    /**
     * Creates an instance of IssueCommentContractProperties class.
     */
    public IssueCommentContractProperties() {
    }

    /**
     * Get the text property: Comment text.
     * 
     * @return the text value.
     */
    public String text() {
        return this.text;
    }

    /**
     * Set the text property: Comment text.
     * 
     * @param text the text value to set.
     * @return the IssueCommentContractProperties object itself.
     */
    public IssueCommentContractProperties withText(String text) {
        this.text = text;
        return this;
    }

    /**
     * Get the createdDate property: Date and time when the comment was created.
     * 
     * @return the createdDate value.
     */
    public OffsetDateTime createdDate() {
        return this.createdDate;
    }

    /**
     * Set the createdDate property: Date and time when the comment was created.
     * 
     * @param createdDate the createdDate value to set.
     * @return the IssueCommentContractProperties object itself.
     */
    public IssueCommentContractProperties withCreatedDate(OffsetDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    /**
     * Get the userId property: A resource identifier for the user who left the comment.
     * 
     * @return the userId value.
     */
    public String userId() {
        return this.userId;
    }

    /**
     * Set the userId property: A resource identifier for the user who left the comment.
     * 
     * @param userId the userId value to set.
     * @return the IssueCommentContractProperties object itself.
     */
    public IssueCommentContractProperties withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (text() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property text in model IssueCommentContractProperties"));
        }
        if (userId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property userId in model IssueCommentContractProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(IssueCommentContractProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("userId", this.userId);
        jsonWriter.writeStringField("createdDate",
            this.createdDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDate));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IssueCommentContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IssueCommentContractProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the IssueCommentContractProperties.
     */
    public static IssueCommentContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IssueCommentContractProperties deserializedIssueCommentContractProperties
                = new IssueCommentContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("text".equals(fieldName)) {
                    deserializedIssueCommentContractProperties.text = reader.getString();
                } else if ("userId".equals(fieldName)) {
                    deserializedIssueCommentContractProperties.userId = reader.getString();
                } else if ("createdDate".equals(fieldName)) {
                    deserializedIssueCommentContractProperties.createdDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIssueCommentContractProperties;
        });
    }
}
