// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.IssueContractBaseProperties;
import com.azure.resourcemanager.apimanagement.models.State;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Issue contract Update Properties.
 */
@Fluent
public final class IssueUpdateContractProperties extends IssueContractBaseProperties {
    /*
     * The issue title.
     */
    private String title;

    /*
     * Text describing the issue.
     */
    private String description;

    /*
     * A resource identifier for the user created the issue.
     */
    private String userId;

    /**
     * Creates an instance of IssueUpdateContractProperties class.
     */
    public IssueUpdateContractProperties() {
    }

    /**
     * Get the title property: The issue title.
     * 
     * @return the title value.
     */
    public String title() {
        return this.title;
    }

    /**
     * Set the title property: The issue title.
     * 
     * @param title the title value to set.
     * @return the IssueUpdateContractProperties object itself.
     */
    public IssueUpdateContractProperties withTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * Get the description property: Text describing the issue.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Text describing the issue.
     * 
     * @param description the description value to set.
     * @return the IssueUpdateContractProperties object itself.
     */
    public IssueUpdateContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the userId property: A resource identifier for the user created the issue.
     * 
     * @return the userId value.
     */
    public String userId() {
        return this.userId;
    }

    /**
     * Set the userId property: A resource identifier for the user created the issue.
     * 
     * @param userId the userId value to set.
     * @return the IssueUpdateContractProperties object itself.
     */
    public IssueUpdateContractProperties withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IssueUpdateContractProperties withCreatedDate(OffsetDateTime createdDate) {
        super.withCreatedDate(createdDate);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IssueUpdateContractProperties withState(State state) {
        super.withState(state);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IssueUpdateContractProperties withApiId(String apiId) {
        super.withApiId(apiId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createdDate",
            createdDate() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(createdDate()));
        jsonWriter.writeStringField("state", state() == null ? null : state().toString());
        jsonWriter.writeStringField("apiId", apiId());
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("userId", this.userId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IssueUpdateContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IssueUpdateContractProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the IssueUpdateContractProperties.
     */
    public static IssueUpdateContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IssueUpdateContractProperties deserializedIssueUpdateContractProperties
                = new IssueUpdateContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("createdDate".equals(fieldName)) {
                    deserializedIssueUpdateContractProperties.withCreatedDate(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("state".equals(fieldName)) {
                    deserializedIssueUpdateContractProperties.withState(State.fromString(reader.getString()));
                } else if ("apiId".equals(fieldName)) {
                    deserializedIssueUpdateContractProperties.withApiId(reader.getString());
                } else if ("title".equals(fieldName)) {
                    deserializedIssueUpdateContractProperties.title = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedIssueUpdateContractProperties.description = reader.getString();
                } else if ("userId".equals(fieldName)) {
                    deserializedIssueUpdateContractProperties.userId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIssueUpdateContractProperties;
        });
    }
}
