// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.LoggerType;
import java.io.IOException;
import java.util.Map;

/**
 * The Logger entity in API Management represents an event sink that you can use to log API Management events. Currently
 * the Logger entity supports logging API Management events to Azure Event Hubs.
 */
@Fluent
public final class LoggerContractProperties implements JsonSerializable<LoggerContractProperties> {
    /*
     * Logger type.
     */
    private LoggerType loggerType;

    /*
     * Logger description.
     */
    private String description;

    /*
     * The name and SendRule connection string of the event hub for azureEventHub logger.
     * Instrumentation key for applicationInsights logger.
     */
    private Map<String, String> credentials;

    /*
     * Whether records are buffered in the logger before publishing. Default is assumed to be true.
     */
    private Boolean isBuffered;

    /*
     * Azure Resource Id of a log target (either Azure Event Hub resource or Azure Application Insights resource).
     */
    private String resourceId;

    /**
     * Creates an instance of LoggerContractProperties class.
     */
    public LoggerContractProperties() {
    }

    /**
     * Get the loggerType property: Logger type.
     * 
     * @return the loggerType value.
     */
    public LoggerType loggerType() {
        return this.loggerType;
    }

    /**
     * Set the loggerType property: Logger type.
     * 
     * @param loggerType the loggerType value to set.
     * @return the LoggerContractProperties object itself.
     */
    public LoggerContractProperties withLoggerType(LoggerType loggerType) {
        this.loggerType = loggerType;
        return this;
    }

    /**
     * Get the description property: Logger description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Logger description.
     * 
     * @param description the description value to set.
     * @return the LoggerContractProperties object itself.
     */
    public LoggerContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the credentials property: The name and SendRule connection string of the event hub for azureEventHub logger.
     * Instrumentation key for applicationInsights logger.
     * 
     * @return the credentials value.
     */
    public Map<String, String> credentials() {
        return this.credentials;
    }

    /**
     * Set the credentials property: The name and SendRule connection string of the event hub for azureEventHub logger.
     * Instrumentation key for applicationInsights logger.
     * 
     * @param credentials the credentials value to set.
     * @return the LoggerContractProperties object itself.
     */
    public LoggerContractProperties withCredentials(Map<String, String> credentials) {
        this.credentials = credentials;
        return this;
    }

    /**
     * Get the isBuffered property: Whether records are buffered in the logger before publishing. Default is assumed to
     * be true.
     * 
     * @return the isBuffered value.
     */
    public Boolean isBuffered() {
        return this.isBuffered;
    }

    /**
     * Set the isBuffered property: Whether records are buffered in the logger before publishing. Default is assumed to
     * be true.
     * 
     * @param isBuffered the isBuffered value to set.
     * @return the LoggerContractProperties object itself.
     */
    public LoggerContractProperties withIsBuffered(Boolean isBuffered) {
        this.isBuffered = isBuffered;
        return this;
    }

    /**
     * Get the resourceId property: Azure Resource Id of a log target (either Azure Event Hub resource or Azure
     * Application Insights resource).
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: Azure Resource Id of a log target (either Azure Event Hub resource or Azure
     * Application Insights resource).
     * 
     * @param resourceId the resourceId value to set.
     * @return the LoggerContractProperties object itself.
     */
    public LoggerContractProperties withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (loggerType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property loggerType in model LoggerContractProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LoggerContractProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("loggerType", this.loggerType == null ? null : this.loggerType.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeMapField("credentials", this.credentials, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isBuffered", this.isBuffered);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LoggerContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LoggerContractProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LoggerContractProperties.
     */
    public static LoggerContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LoggerContractProperties deserializedLoggerContractProperties = new LoggerContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("loggerType".equals(fieldName)) {
                    deserializedLoggerContractProperties.loggerType = LoggerType.fromString(reader.getString());
                } else if ("description".equals(fieldName)) {
                    deserializedLoggerContractProperties.description = reader.getString();
                } else if ("credentials".equals(fieldName)) {
                    Map<String, String> credentials = reader.readMap(reader1 -> reader1.getString());
                    deserializedLoggerContractProperties.credentials = credentials;
                } else if ("isBuffered".equals(fieldName)) {
                    deserializedLoggerContractProperties.isBuffered = reader.getNullable(JsonReader::getBoolean);
                } else if ("resourceId".equals(fieldName)) {
                    deserializedLoggerContractProperties.resourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLoggerContractProperties;
        });
    }
}
