// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.KeyVaultContractProperties;
import java.io.IOException;
import java.util.List;

/**
 * NamedValue details.
 */
@Fluent
public final class NamedValueContractInner extends ProxyResource {
    /*
     * NamedValue entity contract properties.
     */
    private NamedValueContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of NamedValueContractInner class.
     */
    public NamedValueContractInner() {
    }

    /**
     * Get the innerProperties property: NamedValue entity contract properties.
     * 
     * @return the innerProperties value.
     */
    private NamedValueContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the displayName property: Unique name of NamedValue. It may contain only letters, digits, period, dash, and
     * underscore characters.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: Unique name of NamedValue. It may contain only letters, digits, period, dash, and
     * underscore characters.
     * 
     * @param displayName the displayName value to set.
     * @return the NamedValueContractInner object itself.
     */
    public NamedValueContractInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamedValueContractProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the value property: Value of the NamedValue. Can contain policy expressions. It may not be empty or consist
     * only of whitespace. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get
     * the value.
     * 
     * @return the value value.
     */
    public String value() {
        return this.innerProperties() == null ? null : this.innerProperties().value();
    }

    /**
     * Set the value property: Value of the NamedValue. Can contain policy expressions. It may not be empty or consist
     * only of whitespace. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get
     * the value.
     * 
     * @param value the value value to set.
     * @return the NamedValueContractInner object itself.
     */
    public NamedValueContractInner withValue(String value) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamedValueContractProperties();
        }
        this.innerProperties().withValue(value);
        return this;
    }

    /**
     * Get the keyVault property: KeyVault location details of the namedValue.
     * 
     * @return the keyVault value.
     */
    public KeyVaultContractProperties keyVault() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVault();
    }

    /**
     * Set the keyVault property: KeyVault location details of the namedValue.
     * 
     * @param keyVault the keyVault value to set.
     * @return the NamedValueContractInner object itself.
     */
    public NamedValueContractInner withKeyVault(KeyVaultContractProperties keyVault) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamedValueContractProperties();
        }
        this.innerProperties().withKeyVault(keyVault);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the tags property: Optional tags that when provided can be used to filter the NamedValue list.
     * 
     * @return the tags value.
     */
    public List<String> tags() {
        return this.innerProperties() == null ? null : this.innerProperties().tags();
    }

    /**
     * Set the tags property: Optional tags that when provided can be used to filter the NamedValue list.
     * 
     * @param tags the tags value to set.
     * @return the NamedValueContractInner object itself.
     */
    public NamedValueContractInner withTags(List<String> tags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamedValueContractProperties();
        }
        this.innerProperties().withTags(tags);
        return this;
    }

    /**
     * Get the secret property: Determines whether the value is a secret and should be encrypted or not. Default value
     * is false.
     * 
     * @return the secret value.
     */
    public Boolean secret() {
        return this.innerProperties() == null ? null : this.innerProperties().secret();
    }

    /**
     * Set the secret property: Determines whether the value is a secret and should be encrypted or not. Default value
     * is false.
     * 
     * @param secret the secret value to set.
     * @return the NamedValueContractInner object itself.
     */
    public NamedValueContractInner withSecret(Boolean secret) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamedValueContractProperties();
        }
        this.innerProperties().withSecret(secret);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NamedValueContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NamedValueContractInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the NamedValueContractInner.
     */
    public static NamedValueContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NamedValueContractInner deserializedNamedValueContractInner = new NamedValueContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedNamedValueContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedNamedValueContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedNamedValueContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedNamedValueContractInner.innerProperties = NamedValueContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNamedValueContractInner;
        });
    }
}
