// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
 */
@Fluent
public final class NamedValueSecretContractInner implements JsonSerializable<NamedValueSecretContractInner> {
    /*
     * This is secret value of the NamedValue entity.
     */
    private String value;

    /**
     * Creates an instance of NamedValueSecretContractInner class.
     */
    public NamedValueSecretContractInner() {
    }

    /**
     * Get the value property: This is secret value of the NamedValue entity.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: This is secret value of the NamedValue entity.
     * 
     * @param value the value value to set.
     * @return the NamedValueSecretContractInner object itself.
     */
    public NamedValueSecretContractInner withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NamedValueSecretContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NamedValueSecretContractInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NamedValueSecretContractInner.
     */
    public static NamedValueSecretContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NamedValueSecretContractInner deserializedNamedValueSecretContractInner
                = new NamedValueSecretContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedNamedValueSecretContractInner.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNamedValueSecretContractInner;
        });
    }
}
