// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Network Status in the Location.
 */
@Fluent
public final class NetworkStatusContractByLocationInner
    implements JsonSerializable<NetworkStatusContractByLocationInner> {
    /*
     * Location of service
     */
    private String location;

    /*
     * Network status in Location
     */
    private NetworkStatusContractInner networkStatus;

    /**
     * Creates an instance of NetworkStatusContractByLocationInner class.
     */
    public NetworkStatusContractByLocationInner() {
    }

    /**
     * Get the location property: Location of service.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: Location of service.
     * 
     * @param location the location value to set.
     * @return the NetworkStatusContractByLocationInner object itself.
     */
    public NetworkStatusContractByLocationInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the networkStatus property: Network status in Location.
     * 
     * @return the networkStatus value.
     */
    public NetworkStatusContractInner networkStatus() {
        return this.networkStatus;
    }

    /**
     * Set the networkStatus property: Network status in Location.
     * 
     * @param networkStatus the networkStatus value to set.
     * @return the NetworkStatusContractByLocationInner object itself.
     */
    public NetworkStatusContractByLocationInner withNetworkStatus(NetworkStatusContractInner networkStatus) {
        this.networkStatus = networkStatus;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (networkStatus() != null) {
            networkStatus().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("networkStatus", this.networkStatus);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkStatusContractByLocationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkStatusContractByLocationInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkStatusContractByLocationInner.
     */
    public static NetworkStatusContractByLocationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkStatusContractByLocationInner deserializedNetworkStatusContractByLocationInner
                = new NetworkStatusContractByLocationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("location".equals(fieldName)) {
                    deserializedNetworkStatusContractByLocationInner.location = reader.getString();
                } else if ("networkStatus".equals(fieldName)) {
                    deserializedNetworkStatusContractByLocationInner.networkStatus
                        = NetworkStatusContractInner.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkStatusContractByLocationInner;
        });
    }
}
